'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Mixins

// Utilities


var _groupable = require('../../mixins/groupable');

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

var _themeable = require('../../mixins/themeable');

var _themeable2 = _interopRequireDefault(_themeable);

var _helpers = require('./../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var baseMixins = (0, _mixins2.default)(_routable2.default,
// Must be after routable
// to overwrite activeClass
(0, _groupable.factory)('tabsBar'), _themeable2.default);
exports.default = baseMixins.extend().extend().extend({
    name: 'v-tab',
    props: {
        ripple: {
            type: [Boolean, Object],
            default: true
        }
    },
    data: function data() {
        return {
            proxyClass: 'v-tab--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-tab': true
            }, _routable2.default.options.computed.classes.call(this), {
                'v-tab--disabled': this.disabled
            }, this.groupClasses);
        },
        value: function value() {
            var to = this.to || this.href || '';
            if (this.$router && this.to === Object(this.to)) {
                var resolve = this.$router.resolve(this.to, this.$route, this.append);
                to = resolve.href;
            }
            return to.replace('#', '');
        }
    },
    mounted: function mounted() {
        this.onRouteChange();
    },

    methods: {
        click: function click(e) {
            // If user provides an
            // actual link, do not
            // prevent default
            if (this.href && this.href.indexOf('#') > -1) e.preventDefault();
            if (e.detail) this.$el.blur();
            this.$emit('click', e);
            this.to || this.toggle();
        }
    },
    render: function render(h) {
        var _this = this;

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.attrs = _extends({}, data.attrs, {
            'aria-selected': String(this.isActive),
            role: 'tab',
            tabindex: 0
        });
        data.on = _extends({}, data.on, {
            keydown: function keydown(e) {
                if (e.keyCode === _helpers.keyCodes.enter) _this.click(e);
                _this.$emit('keydown', e);
            }
        });
        return h(tag, data, this.$slots.default);
    }
});
//# sourceMappingURL=VTab.js.map