'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.Goto = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Extensions

// Utilities


exports.default = goTo;

var _service = require('../service');

var _easingPatterns = require('./easing-patterns');

var easingPatterns = _interopRequireWildcard(_easingPatterns);

var _util = require('./util');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function goTo(_target) {
    var _settings = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var settings = _extends({
        container: document.scrollingElement || document.body || document.documentElement,
        duration: 500,
        offset: 0,
        easing: 'easeInOutCubic',
        appOffset: true
    }, _settings);
    var container = (0, _util.getContainer)(settings.container);
    /* istanbul ignore else */
    if (settings.appOffset && goTo.framework.application) {
        var isDrawer = container.classList.contains('v-navigation-drawer');
        var isClipped = container.classList.contains('v-navigation-drawer--clipped');
        var _goTo$framework$appli = goTo.framework.application,
            bar = _goTo$framework$appli.bar,
            top = _goTo$framework$appli.top;

        settings.offset += bar;
        /* istanbul ignore else */
        if (!isDrawer || isClipped) settings.offset += top;
    }
    var startTime = performance.now();
    var targetLocation = (0, _util.getOffset)(_target) - settings.offset;
    var startLocation = container.scrollTop;
    if (targetLocation === startLocation) return Promise.resolve(targetLocation);
    var ease = typeof settings.easing === 'function' ? settings.easing : easingPatterns[settings.easing];
    /* istanbul ignore else */
    if (!ease) throw new TypeError('Easing function "' + settings.easing + '" not found.');
    // Cannot be tested properly in jsdom
    // tslint:disable-next-line:promise-must-complete
    /* istanbul ignore next */
    return new Promise(function (resolve) {
        return requestAnimationFrame(function step(currentTime) {
            var timeElapsed = currentTime - startTime;
            var progress = Math.abs(settings.duration ? Math.min(timeElapsed / settings.duration, 1) : 1);
            container.scrollTop = Math.floor(startLocation + (targetLocation - startLocation) * ease(progress));
            if (progress === 1 || container.clientHeight + container.scrollTop === container.scrollHeight) {
                return resolve(targetLocation);
            }
            requestAnimationFrame(step);
        });
    });
}
goTo.framework = {};
goTo.init = function () {};

var Goto = exports.Goto = function (_Service) {
    _inherits(Goto, _Service);

    function Goto() {
        var _ret;

        _classCallCheck(this, Goto);

        var _this = _possibleConstructorReturn(this, (Goto.__proto__ || Object.getPrototypeOf(Goto)).call(this));

        return _ret = goTo, _possibleConstructorReturn(_this, _ret);
    }

    return Goto;
}(_service.Service);

Goto.property = 'goTo';
//# sourceMappingURL=index.js.map