var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VBtnToggle/VBtnToggle.sass';
// Mixins
import ButtonGroup from '../../mixins/button-group';
import Colorable from '../../mixins/colorable';
// Utilities
import mixins from '../../util/mixins';
/* @vue/component */
export default mixins(ButtonGroup, Colorable).extend({
    name: 'v-btn-toggle',
    props: {
        rounded: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, ButtonGroup.options.computed.classes.call(this), {
                'v-btn-toggle': true,
                'v-btn-toggle--rounded': this.rounded
            });
        }
    },
    methods: {
        genData: function genData() {
            return this.setTextColor(this.color, _extends({}, ButtonGroup.options.methods.genData.call(this)));
        }
    }
});
//# sourceMappingURL=VBtnToggle.js.map