var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VChip/VChip.sass';
import mixins from '../../util/mixins';
// Components
import { VExpandXTransition } from '../transitions';
import VIcon from '../VIcon';
// Mixins
import Colorable from '../../mixins/colorable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Themeable from '../../mixins/themeable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
import Routable from '../../mixins/routable';
import Sizeable from '../../mixins/sizeable';
// Directives
import Ripple from '../../directives/ripple';
// Utilities
import { deprecate } from '../../util/console';
/* @vue/component */
export default mixins(Colorable, Sizeable, Routable, Themeable, GroupableFactory('chipGroup'), ToggleableFactory('inputValue')).extend({
    name: 'v-chip',
    directives: { Ripple: Ripple },
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.chipGroup) return '';
                return this.chipGroup.activeClass;
            }
        },
        close: Boolean,
        closeIcon: {
            type: String,
            default: '$vuetify.icons.delete'
        },
        disabled: Boolean,
        draggable: Boolean,
        filter: Boolean,
        filterIcon: {
            type: String,
            default: '$vuetify.icons.complete'
        },
        label: Boolean,
        link: Boolean,
        outline: Boolean,
        outlined: Boolean,
        pill: Boolean,
        // Used for selects/tagging
        selected: Boolean,
        tag: {
            type: String,
            default: 'span'
        },
        textColor: String,
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-chip--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-chip': true
            }, Routable.options.computed.classes.call(this), {
                'v-chip--clickable': this.isClickable,
                'v-chip--disabled': this.disabled,
                'v-chip--draggable': this.draggable,
                'v-chip--label': this.label,
                'v-chip--link': this.isClickable,
                'v-chip--no-color': !this.color,
                'v-chip--outlined': this.hasOutline,
                'v-chip--pill': this.pill,
                'v-chip--removable': this.hasClose
            }, this.themeClasses, this.sizeableClasses, this.groupClasses);
        },
        hasClose: function hasClose() {
            return Boolean(this.close || this.$listeners['click:close']);
        },
        hasOutline: function hasOutline() {
            return this.outline || this.outlined;
        },
        isClickable: function isClickable() {
            return Boolean(Routable.options.computed.isClickable.call(this) || this.chipGroup);
        }
    },
    methods: {
        click: function click(e) {
            this.$emit('click', e);
            this.chipGroup && this.toggle();
        },
        genFilter: function genFilter() {
            var children = [];
            if (this.isActive) {
                children.push(this.$createElement(VIcon, {
                    staticClass: 'v-chip__filter',
                    props: { left: true }
                }, this.filterIcon));
            }
            return this.$createElement(VExpandXTransition, children);
        },
        genClose: function genClose() {
            var _this = this;

            return this.$createElement(VIcon, {
                staticClass: 'v-chip__close',
                props: {
                    right: true
                },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        _this.$emit('click:close');
                    }
                }
            }, this.closeIcon);
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-chip__content'
            }, [this.filter && this.genFilter(), this.$slots.default, this.hasClose && this.genClose()]);
        }
    },
    created: function created() {
        if (this.outline) deprecate('outline', 'outlined', this);
        if (this.selected) deprecate('selected', 'value', this);
    },
    render: function render(h) {
        var children = [this.genContent()];

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.attrs = _extends({}, data.attrs, {
            draggable: this.draggable ? 'true' : undefined,
            tabindex: this.chipGroup && !this.disabled ? 0 : data.attrs.tabindex
        });
        data = this.setBackgroundColor(this.color, data);
        var color = this.textColor || this.hasOutline && this.color;
        return h(tag, this.setTextColor(color, data), children);
    }
});
//# sourceMappingURL=VChip.js.map