// Styles
import '../../../src/components/VColorPicker/VColorPickerSwatches.sass';
// Components
import VIcon from '../VIcon';
// Helpers
import colors from '../../util/colors';
import { fromHex, parseColor } from './util';
import { convertToUnit, deepEqual } from '../../util/helpers';
import mixins from '../../util/mixins';
import Themeable from '../../mixins/themeable';
import { contrastRatio } from '../../util/colorUtils';
function parseDefaultColors(colors) {
    return Object.keys(colors).map(function (key) {
        var color = colors[key];
        return color.base ? [color.base, color.darken4, color.darken3, color.darken2, color.darken1, color.lighten1, color.lighten2, color.lighten3, color.lighten4, color.lighten5] : [color.black, color.white, color.transparent];
    });
}
var white = fromHex('#FFFFFF').rgba;
var black = fromHex('#000000').rgba;
export default mixins(Themeable).extend({
    name: 'v-color-picker-swatches',
    props: {
        swatches: {
            type: Array,
            default: function _default() {
                return parseDefaultColors(colors);
            }
        },
        color: Object,
        maxWidth: [Number, String],
        maxHeight: [Number, String]
    },
    methods: {
        genColor: function genColor(color) {
            var _this = this;

            var content = this.$createElement('div', {
                style: {
                    background: color
                }
            }, [deepEqual(this.color, parseColor(color, null)) && this.$createElement(VIcon, {
                props: {
                    small: true,
                    dark: contrastRatio(this.color.rgba, white) > 2 && this.color.alpha > 0.5,
                    light: contrastRatio(this.color.rgba, black) > 2 && this.color.alpha > 0.5
                }
            }, '$vuetify.icons.success')]);
            return this.$createElement('div', {
                staticClass: 'v-color-picker__color',
                on: {
                    // TODO: Less hacky way of catching transparent
                    click: function click() {
                        return _this.$emit('update:color', fromHex(color === 'transparent' ? '#00000000' : color));
                    }
                }
            }, [content]);
        },
        genSwatches: function genSwatches() {
            var _this2 = this;

            return this.swatches.map(function (swatch) {
                var colors = swatch.map(_this2.genColor);
                return _this2.$createElement('div', {
                    staticClass: 'v-color-picker__swatch'
                }, colors);
            });
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-color-picker__swatches',
            style: {
                maxWidth: convertToUnit(this.maxWidth),
                maxHeight: convertToUnit(this.maxHeight)
            }
        }, [this.$createElement('div', this.genSwatches())]);
    }
});
//# sourceMappingURL=VColorPickerSwatches.js.map