var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

import '../../../src/components/VDataTable/VSimpleTable.sass';
import { convertToUnit } from '../../util/helpers';
import Themeable from '../../mixins/themeable';
import mixins from '../../util/mixins';
export default mixins(Themeable).extend({
    name: 'v-simple-table',
    props: {
        fixedHeader: Boolean,
        height: [Number, String],
        dense: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-data-table--dense': this.dense,
                'v-data-table--fixed-height': !!this.height && !this.fixedHeader,
                'v-data-table--fixed-header': this.fixedHeader
            }, this.themeClasses);
        }
    },
    methods: {
        genWrapper: function genWrapper() {
            return this.$slots.wrapper || this.$createElement('div', {
                staticClass: 'v-data-table__wrapper',
                style: {
                    height: convertToUnit(this.height)
                }
            }, [this.$createElement('table', this.$slots.default)]);
        }
    },
    render: function render(h) {
        return h('div', {
            staticClass: 'v-data-table',
            class: this.classes
        }, [this.$slots.top, this.genWrapper(), this.$slots.bottom]);
    }
});
//# sourceMappingURL=VSimpleTable.js.map