var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VExpansionPanel/VExpansionPanel.sass';
// Components
import { BaseItemGroup } from '../VItemGroup/VItemGroup';
// Utilities
import { breaking } from '../../util/console';
/* @vue/component */
export default BaseItemGroup.extend({
    name: 'v-expansion-panels',
    provide: function provide() {
        return {
            expansionPanels: this
        };
    },

    props: {
        accordion: Boolean,
        disabled: Boolean,
        /** @deprecated */
        expand: Boolean,
        focusable: Boolean,
        inset: Boolean,
        popout: Boolean,
        readonly: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, BaseItemGroup.options.computed.classes.call(this), {
                'v-expansion-panels': true,
                'v-expansion-panels--accordion': this.accordion,
                'v-expansion-panels--focusable': this.focusable,
                'v-expansion-panels--inset': this.inset,
                'v-expansion-panels--popout': this.popout
            });
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.expand) breaking('expand', 'multiple');
        /* istanbul ignore next */
        if (Array.isArray(this.value) && this.value.length > 0 && typeof this.value[0] === 'boolean') {
            breaking('<v-expansion-panels :value="[true, false]">', '<v-expansion-panels :value="[0]">');
        }
    },

    methods: {
        updateItem: function updateItem(item, index) {
            var value = this.getValue(item, index);
            var nextValue = this.getValue(item, index + 1);
            item.isActive = this.toggleMethod(value);
            item.nextIsActive = this.toggleMethod(nextValue);
        }
    }
});
//# sourceMappingURL=VExpansionPanels.js.map