import { createSimpleFunctional } from '../../util/helpers';
import { deprecate } from '../../util/console';
import VList from './VList';
import VListGroup from './VListGroup';
import VListItem from './VListItem';
import VListItemGroup from './VListItemGroup';
import VListItemAction from './VListItemAction';
import VListItemAvatar from './VListItemAvatar';
import VListItemIcon from './VListItemIcon';
export var VListItemActionText = createSimpleFunctional('v-list-item__action-text', 'span');
export var VListItemContent = createSimpleFunctional('v-list-item__content', 'div');
export var VListItemTitle = createSimpleFunctional('v-list-item__title', 'div');
export var VListItemSubtitle = createSimpleFunctional('v-list-item__subtitle', 'div');
var VListTile = VListItem.extend({
    mounted: function mounted() {
        deprecate('v-list-tile', 'v-list-item');
    }
});
var VListTileAction = VListItemAction.extend({
    mounted: function mounted() {
        deprecate('v-list-tile-action', 'v-list-item-action');
    }
});
var VListTileAvatar = VListItemAvatar.extend({
    mounted: function mounted() {
        deprecate('v-list-tile-avatar', 'v-list-item-avatar');
    }
});
var VListTileIcon = VListItemIcon.extend({
    mounted: function mounted() {
        deprecate('v-list-tile-icon', 'v-list-item-icon');
    }
});
var VListTileActionText = VListItemActionText.extend({
    render: function render(h, context) {
        var render = VListItemActionText.options.render.call(this, h, context);
        deprecate('v-list-tile-action-text', 'v-list-item-action-text');
        return render;
    }
});
var VListTileContent = VListItemContent.extend({
    render: function render(h, context) {
        var render = VListItemContent.options.render.call(this, h, context);
        deprecate('v-list-tile-content', 'v-list-item-content');
        return render;
    }
});
var VListTileTitle = VListItemTitle.extend({
    render: function render(h, context) {
        var render = VListItemTitle.options.render.call(this, h, context);
        deprecate('v-list-tile-title', 'v-list-item-title');
        return render;
    }
});
var VListTileSubTitle = VListItemSubtitle.extend({
    render: function render(h, context) {
        var render = VListItemSubtitle.options.render.call(this, h, context);
        deprecate('v-list-tile-subtitle', 'v-list-item-subtitle');
        return render;
    }
});
export { VList, VListGroup, VListItem, VListItemAction, VListItemAvatar, VListItemIcon, VListItemGroup,
// Deprecated
VListTile, VListTileAction, VListTileAvatar, VListTileIcon, VListTileActionText, VListTileContent, VListTileTitle, VListTileSubTitle };
export default {
    $_vuetify_subcomponents: {
        VList: VList,
        VListGroup: VListGroup,
        VListItem: VListItem,
        VListItemAction: VListItemAction,
        VListItemActionText: VListItemActionText,
        VListItemAvatar: VListItemAvatar,
        VListItemContent: VListItemContent,
        VListItemGroup: VListItemGroup,
        VListItemSubtitle: VListItemSubtitle,
        VListItemTitle: VListItemTitle,
        // Deprecated
        VListTile: VListTile,
        VListTileAction: VListTileAction,
        VListTileAvatar: VListTileAvatar,
        VListTileIcon: VListTileIcon,
        VListTileActionText: VListTileActionText,
        VListTileContent: VListTileContent,
        VListTileTitle: VListTileTitle,
        VListTileSubTitle: VListTileSubTitle
    }
};
//# sourceMappingURL=index.js.map