'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _calendarBase = require('./calendar-base');

var _calendarBase2 = _interopRequireDefault(_calendarBase);

var _props = require('../util/props');

var _props2 = _interopRequireDefault(_props);

var _timestamp = require('../util/timestamp');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */

// Util
exports.default = _calendarBase2.default.extend({
    name: 'calendar-with-intervals',
    props: _props2.default.intervals,
    computed: {
        parsedFirstInterval: function parsedFirstInterval() {
            return parseInt(this.firstInterval);
        },
        parsedIntervalMinutes: function parsedIntervalMinutes() {
            return parseInt(this.intervalMinutes);
        },
        parsedIntervalCount: function parsedIntervalCount() {
            return parseInt(this.intervalCount);
        },
        parsedIntervalHeight: function parsedIntervalHeight() {
            return parseFloat(this.intervalHeight);
        },
        firstMinute: function firstMinute() {
            return this.parsedFirstInterval * this.parsedIntervalMinutes;
        },
        bodyHeight: function bodyHeight() {
            return this.parsedIntervalCount * this.parsedIntervalHeight;
        },
        days: function days() {
            return (0, _timestamp.createDayList)(this.parsedStart, this.parsedEnd, this.times.today, this.weekdaySkips, this.maxDays);
        },
        intervals: function intervals() {
            var days = this.days;
            var first = this.parsedFirstInterval;
            var minutes = this.parsedIntervalMinutes;
            var count = this.parsedIntervalCount;
            var now = this.times.now;
            return days.map(function (d) {
                return (0, _timestamp.createIntervalList)(d, first, minutes, count, now);
            });
        },
        intervalFormatter: function intervalFormatter() {
            if (this.intervalFormat) {
                return this.intervalFormat;
            }
            var longOptions = { timeZone: 'UTC', hour12: true, hour: '2-digit', minute: '2-digit' };
            var shortOptions = { timeZone: 'UTC', hour12: true, hour: 'numeric', minute: '2-digit' };
            var shortHourOptions = { timeZone: 'UTC', hour12: true, hour: 'numeric' };
            return (0, _timestamp.createNativeLocaleFormatter)(this.currentLocale, function (tms, short) {
                return short ? tms.minute === 0 ? shortHourOptions : shortOptions : longOptions;
            });
        }
    },
    methods: {
        showIntervalLabelDefault: function showIntervalLabelDefault(interval) {
            var first = this.intervals[0][0];
            var isFirst = first.hour === interval.hour && first.minute === interval.minute;
            return !isFirst && interval.minute === 0;
        },
        intervalStyleDefault: function intervalStyleDefault(_interval) {
            return undefined;
        },
        getTimestampAtEvent: function getTimestampAtEvent(e, day) {
            var timestamp = (0, _timestamp.copyTimestamp)(day);
            var bounds = e.currentTarget.getBoundingClientRect();
            var baseMinutes = this.firstMinute;
            var touchEvent = e;
            var mouseEvent = e;
            var touches = touchEvent.changedTouches || touchEvent.touches;
            var clientY = touches && touches[0] ? touches[0].clientY : mouseEvent.clientY;
            var addIntervals = (clientY - bounds.top) / this.parsedIntervalHeight;
            var addMinutes = Math.floor(addIntervals * this.parsedIntervalMinutes);
            var minutes = baseMinutes + addMinutes;
            return (0, _timestamp.updateMinutes)(timestamp, minutes, this.times.now);
        },
        getSlotScope: function getSlotScope(timestamp) {
            var scope = (0, _timestamp.copyTimestamp)(timestamp);
            scope.timeToY = this.timeToY;
            scope.minutesToPixels = this.minutesToPixels;
            return scope;
        },
        scrollToTime: function scrollToTime(time) {
            var y = this.timeToY(time);
            var pane = this.$refs.scrollArea;
            if (y === false || !pane) {
                return false;
            }
            pane.scrollTop = y;
            return true;
        },
        minutesToPixels: function minutesToPixels(minutes) {
            return minutes / this.parsedIntervalMinutes * this.parsedIntervalHeight;
        },
        timeToY: function timeToY(time) {
            var clamp = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

            var minutes = (0, _timestamp.parseTime)(time);
            if (minutes === false) {
                return false;
            }
            var min = this.firstMinute;
            var gap = this.parsedIntervalCount * this.parsedIntervalMinutes;
            var delta = (minutes - min) / gap;
            var y = delta * this.bodyHeight;
            if (clamp) {
                if (y < 0) {
                    y = 0;
                }
                if (y > this.bodyHeight) {
                    y = this.bodyHeight;
                }
            }
            return y;
        }
    }
}); // Mixins
//# sourceMappingURL=calendar-with-intervals.js.map