'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; // Styles

// Extensions

// Mixins

// Helpers


require('../../../src/components/VCard/VCard.sass');

var _VSheet = require('../VSheet');

var _VSheet2 = _interopRequireDefault(_VSheet);

var _loadable = require('../../mixins/loadable');

var _loadable2 = _interopRequireDefault(_loadable);

var _routable = require('../../mixins/routable');

var _routable2 = _interopRequireDefault(_routable);

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* @vue/component */
exports.default = (0, _mixins2.default)(_loadable2.default, _routable2.default, _VSheet2.default).extend({
    name: 'v-card',
    props: {
        flat: Boolean,
        hover: Boolean,
        img: String,
        link: Boolean,
        loaderHeight: {
            type: [Number, String],
            default: 4
        },
        outlined: Boolean,
        raised: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-card': true
            }, _routable2.default.options.computed.classes.call(this), {
                'v-card--flat': this.flat,
                'v-card--hover': this.hover,
                'v-card--link': this.isClickable,
                'v-card--loading': this.loading,
                'v-card--disabled': this.loading || this.disabled,
                'v-card--outlined': this.outlined,
                'v-card--raised': this.raised
            }, _VSheet2.default.options.computed.classes.call(this));
        },
        styles: function styles() {
            var style = _extends({}, _VSheet2.default.options.computed.styles.call(this));
            if (this.img) {
                style.background = 'url("' + this.img + '") center center / cover no-repeat';
            }
            return style;
        }
    },
    methods: {
        genProgress: function genProgress() {
            var render = _loadable2.default.options.methods.genProgress.call(this);
            if (!render) return null;
            return this.$createElement('div', {
                staticClass: 'v-card__progress'
            }, [render]);
        }
    },
    render: function render(h) {
        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.style = this.styles;
        if (this.isClickable) {
            data.attrs = data.attrs || {};
            data.attrs.tabindex = 0;
        }
        return h(tag, this.setBackgroundColor(this.color, data), [this.genProgress(), this.$slots.default]);
    }
});
//# sourceMappingURL=VCard.js.map