'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _transitions = require('../transitions');

var _bootable = require('../../mixins/bootable');

var _bootable2 = _interopRequireDefault(_bootable);

var _registrable = require('../../mixins/registrable');

var _helpers = require('../../util/helpers');

var _mixins = require('../../util/mixins');

var _mixins2 = _interopRequireDefault(_mixins);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Utilities

// Mixins
var baseMixins = (0, _mixins2.default)(_bootable2.default, (0, _registrable.inject)('expansionPanel', 'v-expansion-panel-content', 'v-expansion-panel'));
/* @vue/component */
exports.default = baseMixins.extend().extend({
    name: 'v-expansion-panel-content',
    computed: {
        isActive: function isActive() {
            return this.expansionPanel.isActive;
        }
    },
    created: function created() {
        this.expansionPanel.registerContent(this);
    },
    beforeDestroy: function beforeDestroy() {
        this.expansionPanel.unregisterContent();
    },
    render: function render(h) {
        return h(_transitions.VExpandTransition, [h('div', {
            staticClass: 'v-expansion-panel-content',
            directives: [{
                name: 'show',
                value: this.isActive
            }]
        }, this.showLazyContent([h('div', { class: 'v-expansion-panel-content__wrap' }, (0, _helpers.getSlot)(this))]))]);
    }
});
//# sourceMappingURL=VExpansionPanelContent.js.map