'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _console = require('../../util/console');

var _vue = require('vue');

var _vue2 = _interopRequireDefault(_vue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Bootable
 * @mixin
 *
 * Used to add lazy content functionality to components
 * Looks for change in "isActive" to automatically boot
 * Otherwise can be set manually
 */
/* @vue/component */
// Utilities
exports.default = _vue2.default.extend().extend({
    name: 'bootable',
    props: {
        eager: Boolean
    },
    data: function data() {
        return {
            isBooted: false
        };
    },
    computed: {
        hasContent: function hasContent() {
            return this.isBooted || this.eager || this.isActive;
        }
    },
    watch: {
        isActive: function isActive() {
            this.isBooted = true;
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if ('lazy' in this.$attrs) {
            (0, _console.removed)('lazy', this);
        }
    },

    methods: {
        showLazyContent: function showLazyContent(content) {
            return this.hasContent ? content : undefined;
        }
    }
});
// Types
//# sourceMappingURL=index.js.map