var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VBtn/VBtn.sass';
// Extensions
import VSheet from '../VSheet';
// Components
import VProgressCircular from '../VProgressCircular';
// Mixins
import { factory as GroupableFactory } from '../../mixins/groupable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
import Positionable from '../../mixins/positionable';
import Routable from '../../mixins/routable';
import Sizeable from '../../mixins/sizeable';
// Utilities
import mixins from '../../util/mixins';
import { breaking } from '../../util/console';
var baseMixins = mixins(VSheet, Routable, Positionable, Sizeable, GroupableFactory('btnToggle'), ToggleableFactory('inputValue')
/* @vue/component */
);
export default baseMixins.extend().extend({
    name: 'v-btn',
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.btnToggle) return '';
                return this.btnToggle.activeClass;
            }
        },
        block: Boolean,
        depressed: Boolean,
        fab: Boolean,
        icon: Boolean,
        loading: Boolean,
        outlined: Boolean,
        rounded: Boolean,
        tag: {
            type: String,
            default: 'button'
        },
        text: Boolean,
        type: {
            type: String,
            default: 'button'
        },
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-btn--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-btn': true
            }, Routable.options.computed.classes.call(this), {
                'v-btn--absolute': this.absolute,
                'v-btn--block': this.block,
                'v-btn--bottom': this.bottom,
                'v-btn--contained': this.contained,
                'v-btn--depressed': this.depressed || this.outlined,
                'v-btn--disabled': this.disabled,
                'v-btn--fab': this.fab || this.icon,
                'v-btn--fixed': this.fixed,
                'v-btn--flat': this.isFlat,
                'v-btn--icon': this.icon,
                'v-btn--left': this.left,
                'v-btn--loading': this.loading,
                'v-btn--outlined': this.outlined,
                'v-btn--right': this.right,
                'v-btn--round': this.isRound,
                'v-btn--rounded': this.rounded,
                'v-btn--router': this.to,
                'v-btn--text': this.text,
                'v-btn--top': this.top
            }, this.themeClasses, this.groupClasses, this.elevationClasses, this.sizeableClasses);
        },
        contained: function contained() {
            return Boolean(!this.isFlat && !this.depressed &&
            // Contained class only adds elevation
            // is not needed if user provides value
            !this.elevation);
        },
        computedRipple: function computedRipple() {
            var defaultRipple = this.icon || this.fab ? { circle: true } : true;
            if (this.disabled) return false;else return this.ripple != null ? this.ripple : defaultRipple;
        },
        isFlat: function isFlat() {
            return Boolean(this.icon || this.text || this.outlined);
        },
        isRound: function isRound() {
            return Boolean(this.icon || this.fab);
        },
        styles: function styles() {
            return _extends({}, this.measurableStyles);
        }
    },
    created: function created() {
        var _this = this;

        var breakingProps = [['flat', 'text'], ['outline', 'outlined'], ['round', 'rounded']];
        /* istanbul ignore next */
        breakingProps.forEach(function (_ref) {
            var _ref2 = _slicedToArray(_ref, 2),
                original = _ref2[0],
                replacement = _ref2[1];

            if (_this.$attrs.hasOwnProperty(original)) breaking(original, replacement, _this);
        });
    },

    methods: {
        // Prevent focus to match md spec
        click: function click(e) {
            !this.fab && e.detail && this.$el.blur();
            this.$emit('click', e);
            this.btnToggle && this.toggle();
        },
        genContent: function genContent() {
            return this.$createElement('span', {
                staticClass: 'v-btn__content'
            }, this.$slots.default);
        },
        genLoader: function genLoader() {
            return this.$createElement('span', {
                class: 'v-btn__loader'
            }, this.$slots.loader || [this.$createElement(VProgressCircular, {
                props: {
                    indeterminate: true,
                    size: 23,
                    width: 2
                }
            })]);
        }
    },
    render: function render(h) {
        var children = [this.genContent(), this.loading && this.genLoader()];
        var setColor = !this.isFlat ? this.setBackgroundColor : this.setTextColor;

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        if (tag === 'button') data.attrs.type = this.type;
        data.attrs.value = ['string', 'number'].includes(_typeof(this.value)) ? this.value : JSON.stringify(this.value);
        return h(tag, setColor(this.color, data), children);
    }
});
//# sourceMappingURL=VBtn.js.map