var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VList/VListItem.sass';
// Mixins
import Colorable from '../../mixins/colorable';
import Routable from '../../mixins/routable';
import { factory as GroupableFactory } from '../../mixins/groupable';
import Themeable from '../../mixins/themeable';
import { factory as ToggleableFactory } from '../../mixins/toggleable';
// Directives
import Ripple from '../../directives/ripple';
// Utilities
import { keyCodes } from './../../util/helpers';
import { removed } from '../../util/console';
// Types
import mixins from '../../util/mixins';
var baseMixins = mixins(Colorable, Routable, Themeable, GroupableFactory('listItemGroup'), ToggleableFactory('inputValue'));
/* @vue/component */
export default baseMixins.extend().extend({
    name: 'v-list-item',
    directives: {
        Ripple: Ripple
    },
    inheritAttrs: false,
    props: {
        activeClass: {
            type: String,
            default: function _default() {
                if (!this.listItemGroup) return '';
                return this.listItemGroup.activeClass;
            }
        },
        dense: Boolean,
        inactive: Boolean,
        link: Boolean,
        tag: {
            type: String,
            default: 'div'
        },
        threeLine: Boolean,
        twoLine: Boolean,
        value: null
    },
    data: function data() {
        return {
            proxyClass: 'v-list-item--active'
        };
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-list-item': true
            }, Routable.options.computed.classes.call(this), {
                'v-list-item--dense': this.dense,
                'v-list-item--disabled': this.disabled,
                'v-list-item--link': this.isClickable && !this.inactive,
                'v-list-item--three-line': this.threeLine,
                'v-list-item--two-line': this.twoLine
            }, this.themeClasses);
        },
        isClickable: function isClickable() {
            return Boolean(Routable.options.computed.isClickable.call(this) || this.listItemGroup);
        }
    },
    created: function created() {
        /* istanbul ignore next */
        if (this.$attrs.hasOwnProperty('avatar')) {
            removed('avatar', this);
        }
    },

    methods: {
        click: function click(e) {
            if (e.detail) this.$el.blur();
            this.$emit('click', e);
            this.to || this.toggle();
        }
    },
    render: function render(h) {
        var _this = this;

        var _generateRouteLink = this.generateRouteLink(),
            tag = _generateRouteLink.tag,
            data = _generateRouteLink.data;

        data.attrs = _extends({}, data.attrs, {
            'aria-selected': String(this.isActive),
            role: 'listitem',
            tabindex: tag === 'a' && this.isClickable ? 0 : -1
        });
        data.on = _extends({}, data.on, {
            click: this.click,
            keydown: function keydown(e) {
                /* istanbul ignore else */
                if (e.keyCode === keyCodes.enter) _this.click(e);
                _this.$emit('keydown', e);
            }
        });
        var children = this.$scopedSlots.default ? this.$scopedSlots.default({
            active: this.isActive,
            toggle: this.toggle
        }) : this.$slots.default;
        tag = this.inactive ? 'div' : tag;
        return h(tag, this.setTextColor(this.color, data), children);
    }
});
//# sourceMappingURL=VListItem.js.map