var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Components
import VAvatar from '../VAvatar';
/* @vue/component */
export default VAvatar.extend({
    name: 'v-list-item-avatar',
    props: {
        horizontal: Boolean,
        size: {
            type: [Number, String],
            default: 40
        }
    },
    computed: {
        classes: function classes() {
            return _extends({
                'v-list-item__avatar--horizontal': this.horizontal
            }, VAvatar.options.computed.classes.call(this), {
                'v-avatar--tile': this.tile || this.horizontal
            });
        }
    },
    render: function render(h) {
        var render = VAvatar.options.render.call(this, h);
        render.data = render.data || {};
        render.data.staticClass += ' v-list-item__avatar';
        return render;
    }
});
//# sourceMappingURL=VListItemAvatar.js.map