var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

// Styles
import '../../../src/components/VOverflowBtn/VOverflowBtn.sass';
// Extensions
import VSelect from '../VSelect/VSelect';
import VAutocomplete from '../VAutocomplete';
import VTextField from '../VTextField/VTextField';
// Components
import VBtn from '../VBtn';
// Utilities
import { consoleWarn } from '../../util/console';
/* @vue/component */
export default VAutocomplete.extend({
    name: 'v-overflow-btn',
    props: {
        segmented: Boolean,
        editable: Boolean
    },
    computed: {
        classes: function classes() {
            return _extends({}, VAutocomplete.options.computed.classes.call(this), {
                'v-overflow-btn': true,
                'v-overflow-btn--segmented': this.segmented,
                'v-overflow-btn--editable': this.editable
            });
        },
        isAnyValueAllowed: function isAnyValueAllowed() {
            return this.editable || VAutocomplete.options.computed.isAnyValueAllowed.call(this);
        },
        isSingle: function isSingle() {
            return true;
        },
        computedItems: function computedItems() {
            return this.segmented ? this.allItems : this.filteredItems;
        }
    },
    methods: {
        genSelections: function genSelections() {
            return this.editable ? VAutocomplete.options.methods.genSelections.call(this) : VSelect.options.methods.genSelections.call(this); // Override v-autocomplete's override
        },
        genCommaSelection: function genCommaSelection(item, index, last) {
            return this.segmented ? this.genSegmentedBtn(item) : VSelect.options.methods.genCommaSelection.call(this, item, index, last);
        },
        genInput: function genInput() {
            var input = VTextField.options.methods.genInput.call(this);
            input.data = input.data || {};
            input.data.domProps.value = this.editable ? this.internalSearch : '';
            input.data.attrs.readonly = !this.isAnyValueAllowed;
            return input;
        },
        genLabel: function genLabel() {
            if (this.editable && this.isFocused) return null;
            var label = VTextField.options.methods.genLabel.call(this);
            if (!label) return label;
            label.data = label.data || {};
            // Reset previously set styles from parent
            label.data.style = {};
            return label;
        },
        genSegmentedBtn: function genSegmentedBtn(item) {
            var _this = this;

            var itemValue = this.getValue(item);
            var itemObj = this.computedItems.find(function (i) {
                return _this.getValue(i) === itemValue;
            }) || item;
            if (!itemObj.text || !itemObj.callback) {
                consoleWarn('When using \'segmented\' prop without a selection slot, items must contain both a text and callback property', this);
                return null;
            }
            return this.$createElement(VBtn, {
                props: { text: true },
                on: {
                    click: function click(e) {
                        e.stopPropagation();
                        itemObj.callback(e);
                    }
                }
            }, [itemObj.text]);
        }
    }
});
//# sourceMappingURL=VOverflowBtn.js.map