var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

import '../../../src/components/VSlider/VSlider.sass';
// Components
import VInput from '../VInput';
import { VScaleTransition } from '../transitions';
// Mixins
import mixins from '../../util/mixins';
import Loadable from '../../mixins/loadable';
// Directives
import ClickOutside from '../../directives/click-outside';
// Helpers
import { addOnceEventListener, deepEqual, keyCodes, createRange, convertToUnit } from '../../util/helpers';
import { consoleWarn } from '../../util/console';
export default mixins(VInput, Loadable
/* @vue/component */
).extend({
    name: 'v-slider',
    directives: {
        ClickOutside: ClickOutside
    },
    mixins: [Loadable],
    props: {
        color: {
            type: String,
            default: 'primary'
        },
        disabled: Boolean,
        inverseLabel: Boolean,
        min: {
            type: [Number, String],
            default: 0
        },
        max: {
            type: [Number, String],
            default: 100
        },
        step: {
            type: [Number, String],
            default: 1
        },
        ticks: {
            type: [Boolean, String],
            default: false,
            validator: function validator(v) {
                return typeof v === 'boolean' || v === 'always';
            }
        },
        tickLabels: {
            type: Array,
            default: function _default() {
                return [];
            }
        },
        tickSize: {
            type: [Number, String],
            default: 2
        },
        thumbColor: {
            type: String,
            default: 'primary'
        },
        thumbLabel: {
            type: [Boolean, String],
            default: null,
            validator: function validator(v) {
                return typeof v === 'boolean' || v === 'always';
            }
        },
        thumbSize: {
            type: [Number, String],
            default: 32
        },
        trackColor: {
            type: String,
            default: 'primary lighten-3'
        },
        value: [Number, String],
        vertical: Boolean
    },
    data: function data() {
        return {
            app: null,
            oldValue: null,
            keyPressed: 0,
            isFocused: false,
            isActive: false,
            lazyValue: 0
        };
    },
    computed: {
        classes: function classes() {
            return _extends({}, VInput.options.computed.classes.call(this), {
                'v-input__slider': true,
                'v-input__slider--vertical': this.vertical,
                'v-input__slider--inverse-label': this.inverseLabel
            });
        },

        internalValue: {
            get: function get() {
                return this.lazyValue;
            },
            set: function set(val) {
                val = isNaN(val) ? this.minValue : val;
                // Round value to ensure the
                // entire slider range can
                // be selected with step
                var value = this.roundValue(Math.min(Math.max(val, this.minValue), this.maxValue));
                if (value === this.lazyValue) return;
                this.lazyValue = value;
                this.$emit('input', value);
            }
        },
        trackTransition: function trackTransition() {
            return this.keyPressed >= 2 ? 'none' : '';
        },
        minValue: function minValue() {
            return parseFloat(this.min);
        },
        maxValue: function maxValue() {
            return parseFloat(this.max);
        },
        stepNumeric: function stepNumeric() {
            return this.step > 0 ? parseFloat(this.step) : 0;
        },
        inputWidth: function inputWidth() {
            var value = (this.roundValue(this.internalValue) - this.minValue) / (this.maxValue - this.minValue) * 100;
            return value;
        },
        trackFillStyles: function trackFillStyles() {
            var _ref;

            var startDir = this.vertical ? 'bottom' : 'left';
            var endDir = this.vertical ? 'top' : 'right';
            var valueDir = this.vertical ? 'height' : 'width';
            var start = this.$vuetify.rtl ? 'auto' : '0';
            var end = this.$vuetify.rtl ? '0' : 'auto';
            var value = this.disabled ? 'calc(' + this.inputWidth + '% - 10px)' : this.inputWidth + '%';
            return _ref = {
                transition: this.trackTransition
            }, _defineProperty(_ref, startDir, start), _defineProperty(_ref, endDir, end), _defineProperty(_ref, valueDir, value), _ref;
        },
        trackStyles: function trackStyles() {
            var _ref2;

            var startDir = this.vertical ? this.$vuetify.rtl ? 'bottom' : 'top' : this.$vuetify.rtl ? 'left' : 'right';
            var endDir = this.vertical ? 'height' : 'width';
            var start = '0px';
            var end = this.disabled ? 'calc(' + (100 - this.inputWidth) + '% - 10px)' : 'calc(' + (100 - this.inputWidth) + '%)';
            return _ref2 = {
                transition: this.trackTransition
            }, _defineProperty(_ref2, startDir, start), _defineProperty(_ref2, endDir, end), _ref2;
        },
        showTicks: function showTicks() {
            return this.tickLabels.length > 0 || !!(!this.disabled && this.stepNumeric && this.ticks);
        },
        numTicks: function numTicks() {
            return Math.ceil((this.maxValue - this.minValue) / this.stepNumeric);
        },
        showThumbLabel: function showThumbLabel() {
            return !this.disabled && !!(this.thumbLabel || this.$scopedSlots['thumb-label']);
        },
        computedColor: function computedColor() {
            if (this.disabled) return false;
            return this.validationState || this.color;
        },
        computedTrackColor: function computedTrackColor() {
            if (this.disabled) return false;
            return this.validationState || this.trackColor;
        },
        computedThumbColor: function computedThumbColor() {
            if (this.disabled) return false;
            return this.validationState || this.thumbColor || this.color;
        }
    },
    watch: {
        min: function min(val) {
            var parsed = parseFloat(val);
            parsed > this.internalValue && this.$emit('input', parsed);
        },
        max: function max(val) {
            var parsed = parseFloat(val);
            parsed < this.internalValue && this.$emit('input', parsed);
        },

        value: {
            handler: function handler(v) {
                this.internalValue = v;
            }
        }
    },
    // If done in as immediate in
    // value watcher, causes issues
    // with vue-test-utils
    beforeMount: function beforeMount() {
        this.internalValue = this.value;
    },
    mounted: function mounted() {
        // Without a v-app, iOS does not work with body selectors
        this.app = document.querySelector('[data-app]') || consoleWarn('Missing v-app or a non-body wrapping element with the [data-app] attribute', this);
    },

    methods: {
        genDefaultSlot: function genDefaultSlot() {
            var children = [this.genLabel()];
            var slider = this.genSlider();
            this.inverseLabel ? children.unshift(slider) : children.push(slider);
            children.push(this.genProgress());
            return children;
        },
        genSlider: function genSlider() {
            return this.$createElement('div', {
                class: _extends({
                    'v-slider': true,
                    'v-slider--horizontal': !this.vertical,
                    'v-slider--vertical': this.vertical,
                    'v-slider--focused': this.isFocused,
                    'v-slider--active': this.isActive,
                    'v-slider--disabled': this.disabled,
                    'v-slider--readonly': this.readonly
                }, this.themeClasses),
                directives: [{
                    name: 'click-outside',
                    value: this.onBlur
                }],
                on: {
                    click: this.onSliderClick
                }
            }, this.genChildren());
        },
        genChildren: function genChildren() {
            return [this.genInput(), this.genTrackContainer(), this.genSteps(), this.genThumbContainer(this.internalValue, this.inputWidth, this.isActive, this.isFocused, this.onThumbMouseDown, this.onFocus)];
        },
        genInput: function genInput() {
            return this.$createElement('input', {
                attrs: _extends({
                    value: this.internalValue,
                    id: this.id,
                    disabled: this.disabled,
                    readonly: true,
                    tabindex: -1
                }, this.$attrs)
            });
        },
        genTrackContainer: function genTrackContainer() {
            var children = [this.$createElement('div', this.setBackgroundColor(this.computedTrackColor, {
                staticClass: 'v-slider__track-background',
                style: this.trackStyles
            })), this.$createElement('div', this.setBackgroundColor(this.computedColor, {
                staticClass: 'v-slider__track-fill',
                style: this.trackFillStyles
            }))];
            return this.$createElement('div', {
                staticClass: 'v-slider__track-container',
                ref: 'track'
            }, children);
        },
        genSteps: function genSteps() {
            var _this = this;

            if (!this.step || !this.showTicks) return null;
            var tickSize = parseFloat(this.tickSize);
            var range = createRange(this.numTicks + 1);
            var direction = this.vertical ? 'bottom' : 'left';
            var offsetDirection = this.vertical ? 'right' : 'top';
            if (this.vertical) range.reverse();
            var ticks = range.map(function (i) {
                var _style;

                var index = _this.$vuetify.rtl ? _this.maxValue - i : i;
                var children = [];
                if (_this.tickLabels[index]) {
                    children.push(_this.$createElement('div', {
                        staticClass: 'v-slider__tick-label'
                    }, _this.tickLabels[index]));
                }
                var width = i * (100 / _this.numTicks);
                var filled = _this.$vuetify.rtl ? 100 - _this.inputWidth < width : width < _this.inputWidth;
                return _this.$createElement('span', {
                    key: i,
                    staticClass: 'v-slider__tick',
                    class: {
                        'v-slider__tick--filled': filled
                    },
                    style: (_style = {
                        width: tickSize + 'px',
                        height: tickSize + 'px'
                    }, _defineProperty(_style, direction, 'calc(' + width + '% - ' + tickSize / 2 + 'px)'), _defineProperty(_style, offsetDirection, 'calc(50% - ' + tickSize / 2 + 'px)'), _style)
                }, children);
            });
            return this.$createElement('div', {
                staticClass: 'v-slider__ticks-container',
                class: {
                    'v-slider__ticks-container--always-show': this.ticks === 'always' || this.tickLabels.length > 0
                }
            }, ticks);
        },
        genThumbContainer: function genThumbContainer(value, valueWidth, isActive, isFocused, onDrag, onFocus) {
            var ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : 'thumb';

            var children = [this.genThumb()];
            var thumbLabelContent = this.genThumbLabelContent(value);
            this.showThumbLabel && children.push(this.genThumbLabel(thumbLabelContent));
            return this.$createElement('div', this.setTextColor(this.computedThumbColor, {
                ref: ref,
                staticClass: 'v-slider__thumb-container',
                class: {
                    'v-slider__thumb-container--active': isActive,
                    'v-slider__thumb-container--focused': isFocused,
                    'v-slider__thumb-container--show-label': this.showThumbLabel
                },
                style: this.getThumbContainerStyles(valueWidth),
                attrs: _extends({
                    role: 'slider',
                    tabindex: this.disabled || this.readonly ? -1 : this.$attrs.tabindex ? this.$attrs.tabindex : 0,
                    'aria-label': this.label,
                    'aria-valuemin': this.min,
                    'aria-valuemax': this.max,
                    'aria-valuenow': this.internalValue,
                    'aria-readonly': String(this.readonly),
                    'aria-orientation': this.vertical ? 'vertical' : 'horizontal'
                }, this.$attrs),
                on: {
                    focus: onFocus,
                    blur: this.onBlur,
                    keydown: this.onKeyDown,
                    keyup: this.onKeyUp,
                    touchstart: onDrag,
                    mousedown: onDrag
                }
            }), children);
        },
        genThumbLabelContent: function genThumbLabelContent(value) {
            return this.$scopedSlots['thumb-label'] ? this.$scopedSlots['thumb-label']({ value: value }) : [this.$createElement('span', [String(value)])];
        },
        genThumbLabel: function genThumbLabel(content) {
            var size = convertToUnit(this.thumbSize);
            var transform = this.vertical ? 'translateY(20%) translateY(' + (Number(this.thumbSize) / 3 - 1) + 'px) translateX(55%) rotate(135deg)' : 'translateY(-20%) translateY(-12px) translateX(-50%) rotate(45deg)';
            return this.$createElement(VScaleTransition, {
                props: { origin: 'bottom center' }
            }, [this.$createElement('div', {
                staticClass: 'v-slider__thumb-label-container',
                directives: [{
                    name: 'show',
                    value: this.isFocused || this.isActive || this.thumbLabel === 'always'
                }]
            }, [this.$createElement('div', this.setBackgroundColor(this.computedThumbColor, {
                staticClass: 'v-slider__thumb-label',
                style: {
                    height: size,
                    width: size,
                    transform: transform
                }
            }), [this.$createElement('div', content)])])]);
        },
        genThumb: function genThumb() {
            return this.$createElement('div', this.setBackgroundColor(this.computedThumbColor, {
                staticClass: 'v-slider__thumb'
            }));
        },
        getThumbContainerStyles: function getThumbContainerStyles(width) {
            var direction = this.vertical ? 'top' : 'left';
            var value = this.$vuetify.rtl ? 100 - width : width;
            value = this.vertical ? 100 - value : value;
            return _defineProperty({
                transition: this.trackTransition
            }, direction, value + '%');
        },
        onThumbMouseDown: function onThumbMouseDown(e) {
            this.oldValue = this.internalValue;
            this.keyPressed = 2;
            var options = { passive: true };
            this.isActive = true;
            if ('touches' in e) {
                this.app.addEventListener('touchmove', this.onMouseMove, options);
                addOnceEventListener(this.app, 'touchend', this.onSliderMouseUp);
            } else {
                this.app.addEventListener('mousemove', this.onMouseMove, options);
                addOnceEventListener(this.app, 'mouseup', this.onSliderMouseUp);
            }
            this.$emit('start', this.internalValue);
        },
        onSliderMouseUp: function onSliderMouseUp() {
            this.keyPressed = 0;
            var options = { passive: true };
            this.app.removeEventListener('touchmove', this.onMouseMove, options);
            this.app.removeEventListener('mousemove', this.onMouseMove, options);
            this.$emit('end', this.internalValue);
            if (!deepEqual(this.oldValue, this.internalValue)) {
                this.$emit('change', this.internalValue);
            }
            this.isActive = false;
        },
        onMouseMove: function onMouseMove(e) {
            var _parseMouseMove = this.parseMouseMove(e),
                value = _parseMouseMove.value;

            this.internalValue = value;
        },
        onKeyDown: function onKeyDown(e) {
            if (this.disabled || this.readonly) return;
            var value = this.parseKeyDown(e, this.internalValue);
            if (value == null) return;
            this.internalValue = value;
            this.$emit('change', value);
        },
        onKeyUp: function onKeyUp() {
            this.keyPressed = 0;
        },
        onSliderClick: function onSliderClick(e) {
            var thumb = this.$refs.thumb;
            thumb.focus();
            this.onMouseMove(e);
            this.$emit('change', this.internalValue);
        },
        onBlur: function onBlur(e) {
            this.isFocused = false;
            this.$emit('blur', e);
        },
        onFocus: function onFocus(e) {
            this.isFocused = true;
            this.$emit('focus', e);
        },
        parseMouseMove: function parseMouseMove(e) {
            var start = this.vertical ? 'top' : 'left';
            var length = this.vertical ? 'height' : 'width';
            var click = this.vertical ? 'clientY' : 'clientX';

            var _$refs$track$getBound = this.$refs.track.getBoundingClientRect(),
                trackStart = _$refs$track$getBound[start],
                trackLength = _$refs$track$getBound[length];

            var clickOffset = 'touches' in e ? e.touches[0][click] : e[click]; // Can we get rid of any here?
            // It is possible for left to be NaN, force to number
            var clickPos = Math.min(Math.max((clickOffset - trackStart) / trackLength, 0), 1) || 0;
            if (this.vertical) clickPos = 1 - clickPos;
            if (this.$vuetify.rtl) clickPos = 1 - clickPos;
            var isInsideTrack = clickOffset >= trackStart && clickOffset <= trackStart + trackLength;
            var value = parseFloat(this.min) + clickPos * (this.maxValue - this.minValue);
            return { value: value, isInsideTrack: isInsideTrack };
        },
        parseKeyDown: function parseKeyDown(e, value) {
            if (this.disabled) return;
            var pageup = keyCodes.pageup,
                pagedown = keyCodes.pagedown,
                end = keyCodes.end,
                home = keyCodes.home,
                left = keyCodes.left,
                right = keyCodes.right,
                down = keyCodes.down,
                up = keyCodes.up;

            if (![pageup, pagedown, end, home, left, right, down, up].includes(e.keyCode)) return;
            e.preventDefault();
            var step = this.stepNumeric || 1;
            var steps = (this.maxValue - this.minValue) / step;
            if ([left, right, down, up].includes(e.keyCode)) {
                this.keyPressed += 1;
                var increase = this.$vuetify.rtl ? [left, up] : [right, up];
                var direction = increase.includes(e.keyCode) ? 1 : -1;
                var multiplier = e.shiftKey ? 3 : e.ctrlKey ? 2 : 1;
                value = value + direction * step * multiplier;
            } else if (e.keyCode === home) {
                value = this.minValue;
            } else if (e.keyCode === end) {
                value = this.maxValue;
            } else {
                var _direction = e.keyCode === pagedown ? 1 : -1;
                value = value - _direction * step * (steps > 100 ? steps / 10 : 10);
            }
            return value;
        },
        roundValue: function roundValue(value) {
            if (!this.stepNumeric) return value;
            // Format input value using the same number
            // of decimals places as in the step prop
            var trimmedStep = this.step.toString().trim();
            var decimals = trimmedStep.indexOf('.') > -1 ? trimmedStep.length - trimmedStep.indexOf('.') - 1 : 0;
            var offset = this.minValue % this.stepNumeric;
            var newValue = Math.round((value - offset) / this.stepNumeric) * this.stepNumeric + offset;
            return parseFloat(Math.min(newValue, this.maxValue).toFixed(decimals));
        }
    }
});
//# sourceMappingURL=VSlider.js.map