import { createVNode as _createVNode } from "vue";
// Styles
import "./VAppBarTitle.css"; // Composables

import { makeTagProps } from "../../composables/tag.mjs"; // Utilities

import { defineComponent } from "../../util/index.mjs";
export default defineComponent({
  name: 'VAppBarTitle',
  props: { ...makeTagProps({
      tag: 'header'
    })
  },

  setup(props, {
    slots
  }) {
    return () => _createVNode(props.tag, {
      "class": "v-app-bar-title"
    }, {
      default: () => [slots.default && _createVNode("div", {
        "class": "v-app-bar-title__placeholder"
      }, [slots.default()])]
    });
  }

});
//# sourceMappingURL=VAppBarTitle.mjs.map