// @ts-nocheck

/* eslint-disable */
// Styles
import "./VColorPickerEdit.css"; // Components

import VBtn from "../VBtn/index.mjs";
import VIcon from "../VIcon/index.mjs"; // Helpers

import { parseHex } from "../../util/colorUtils.mjs"; // Types

import Vue from 'vue';
import { fromRGBA, fromHexa, fromHSLA } from "./util/index.mjs";
export const modes = {
  rgba: {
    inputs: [['r', 255, 'int'], ['g', 255, 'int'], ['b', 255, 'int'], ['a', 1, 'float']],
    from: fromRGBA
  },
  hsla: {
    inputs: [['h', 360, 'int'], ['s', 1, 'float'], ['l', 1, 'float'], ['a', 1, 'float']],
    from: fromHSLA
  },
  hexa: {
    from: fromHexa
  }
};
export default Vue.extend({
  name: 'v-color-picker-edit',
  props: {
    color: Object,
    disabled: Boolean,
    hideAlpha: Boolean,
    hideModeSwitch: Boolean,
    mode: {
      type: String,
      default: 'rgba',
      validator: v => Object.keys(modes).includes(v)
    }
  },

  data() {
    return {
      modes,
      internalMode: this.mode
    };
  },

  computed: {
    currentMode() {
      return this.modes[this.internalMode];
    }

  },
  watch: {
    mode(mode) {
      this.internalMode = mode;
    }

  },

  created() {
    this.internalMode = this.mode;
  },

  methods: {
    getValue(v, type) {
      if (type === 'float') return Math.round(v * 100) / 100;else if (type === 'int') return Math.round(v);else return 0;
    },

    parseValue(v, type) {
      if (type === 'float') return parseFloat(v);else if (type === 'int') return parseInt(v, 10) || 0;else return 0;
    },

    changeMode() {
      const modes = Object.keys(this.modes);
      const index = modes.indexOf(this.internalMode);
      const newMode = modes[(index + 1) % modes.length];
      this.internalMode = newMode;
      this.$emit('update:mode', newMode);
    },

    genInput(target, attrs, value, on) {
      return this.$createElement('div', {
        staticClass: 'v-color-picker__input'
      }, [this.$createElement('input', {
        key: target,
        attrs,
        domProps: {
          value
        },
        on
      }), this.$createElement('span', target.toUpperCase())]);
    },

    genInputs() {
      if (this.internalMode === 'hexa') {
        const hex = this.color.hexa;
        const value = this.hideAlpha && hex.endsWith('FF') ? hex.substr(0, 7) : hex;
        return this.genInput('hex', {
          maxlength: this.hideAlpha ? 7 : 9,
          disabled: this.disabled
        }, value, {
          change: e => {
            const el = e.target;
            this.$emit('update:color', this.currentMode.from(parseHex(el.value)));
          }
        });
      } else {
        const inputs = this.hideAlpha ? this.currentMode.inputs.slice(0, -1) : this.currentMode.inputs;
        return inputs.map(([target, max, type]) => {
          const value = this.color[this.internalMode];
          return this.genInput(target, {
            type: 'number',
            min: 0,
            max,
            step: type === 'float' ? '0.01' : type === 'int' ? '1' : undefined,
            disabled: this.disabled
          }, this.getValue(value[target], type), {
            input: e => {
              const el = e.target;
              const newVal = this.parseValue(el.value || '0', type);
              this.$emit('update:color', this.currentMode.from(Object.assign({}, value, {
                [target]: newVal
              }), this.color.alpha));
            }
          });
        });
      }
    },

    genSwitch() {
      return this.$createElement(VBtn, {
        props: {
          small: true,
          icon: true,
          disabled: this.disabled
        },
        on: {
          click: this.changeMode
        }
      }, [this.$createElement(VIcon, '$unfold')]);
    }

  },

  render(h) {
    return h('div', {
      staticClass: 'v-color-picker__edit'
    }, [this.genInputs(), !this.hideModeSwitch && this.genSwitch()]);
  }

});
//# sourceMappingURL=VColorPickerEdit.mjs.map