import { createVNode as _createVNode } from "vue";
// Styles
import "./VLayout.css"; // Utilities

import { defineComponent, useRender } from "../../util/index.mjs"; // Composables

import { createLayout, makeLayoutProps } from "../../composables/layout.mjs";
export default defineComponent({
  name: 'VLayout',
  props: makeLayoutProps(),

  setup(props, {
    slots
  }) {
    const {
      layoutClasses,
      getLayoutItem,
      items
    } = createLayout(props);
    useRender(() => {
      var _slots$default;

      return _createVNode("div", {
        "class": layoutClasses.value
      }, [(_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)], 2);
    });
    return {
      getLayoutItem,
      items
    };
  }

});
//# sourceMappingURL=VLayout.mjs.map