import { createVNode as _createVNode } from "vue";
// Styles
import "./VList.css"; // Components
// import { VListItem } from '.'

import VListSubheader from "./VListSubheader.mjs"; // Composables

import { makeBorderProps, useBorder } from "../../composables/border.mjs";
import { makeDensityProps, useDensity } from "../../composables/density.mjs";
import { makeDimensionProps, useDimension } from "../../composables/dimensions.mjs";
import { makeElevationProps, useElevation } from "../../composables/elevation.mjs";
import { makeRoundedProps, useRounded } from "../../composables/rounded.mjs";
import { makeTagProps } from "../../composables/tag.mjs";
import { useBackgroundColor } from "../../composables/color.mjs";
import { makeThemeProps, useTheme } from "../../composables/theme.mjs"; // Utilities

import { toRef } from 'vue';
import { defineComponent } from "../../util/index.mjs";
export default defineComponent({
  name: 'VList',
  props: {
    color: String,
    disabled: Boolean,
    lines: {
      type: String,
      default: 'one'
    },
    nav: Boolean,
    subheader: {
      type: [Boolean, String],
      default: false
    },
    ...makeBorderProps(),
    ...makeDensityProps(),
    ...makeDimensionProps(),
    ...makeElevationProps(),
    ...makeRoundedProps(),
    ...makeTagProps(),
    ...makeThemeProps()
  },

  setup(props, {
    slots
  }) {
    const {
      themeClasses
    } = useTheme(props);
    const {
      backgroundColorClasses,
      backgroundColorStyles
    } = useBackgroundColor(toRef(props, 'color'));
    const {
      borderClasses
    } = useBorder(props, 'v-list');
    const {
      densityClasses
    } = useDensity(props, 'v-list');
    const {
      dimensionStyles
    } = useDimension(props);
    const {
      elevationClasses
    } = useElevation(props);
    const {
      roundedClasses
    } = useRounded(props, 'v-list');
    return () => {
      var _slots$default;

      const hasHeader = typeof props.subheader === 'string' || slots.subheader;
      return _createVNode(props.tag, {
        "class": ['v-list', {
          'v-list--disabled': props.disabled,
          'v-list--nav': props.nav,
          'v-list--subheader': props.subheader,
          'v-list--subheader-sticky': props.subheader === 'sticky',
          [`v-list--${props.lines}-line`]: true
        }, themeClasses.value, backgroundColorClasses.value, borderClasses.value, densityClasses.value, elevationClasses.value, roundedClasses.value],
        "style": [backgroundColorStyles.value, dimensionStyles.value]
      }, {
        default: () => [hasHeader && (slots.subheader ? slots.subheader() : _createVNode(VListSubheader, null, {
          default: () => [props.subheader]
        })), (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots)],
        _: 1
      }, 8, ["class", "style"]);
    };
  }

});
//# sourceMappingURL=VList.mjs.map