// Utilities
import { defineComponent, IN_BROWSER } from "../../util/index.mjs";
import { onMounted, ref } from 'vue';

function doesHydrate(fn) {
  var _document$querySelect;

  if (!IN_BROWSER) return; // @ts-expect-error

  return (_document$querySelect = document.querySelector('#app')) != null && _document$querySelect.__vue_app__ ? fn() : onMounted(fn);
}

export default defineComponent({
  name: 'VNoSsr',

  setup(_, {
    slots
  }) {
    const show = ref(false);
    doesHydrate(() => {
      show.value = true;
    });
    return () => {
      var _slots$default;

      return show.value && ((_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots));
    };
  }

});
//# sourceMappingURL=VNoSsr.mjs.map