import { withDirectives as _withDirectives, mergeProps as _mergeProps, resolveDirective as _resolveDirective, vModelDynamic as _vModelDynamic, createVNode as _createVNode, Fragment as _Fragment } from "vue";
// Styles
import "./VTextField.css"; // Components

import { makeVFieldProps } from "../VField/VField.mjs";
import { VCounter } from "../VCounter/index.mjs";
import { VField } from "../VField/index.mjs"; // Composables

import { useProxiedModel } from "../../composables/proxiedModel.mjs"; // Directives

import Intersect from "../../directives/intersect/index.mjs"; // Utilities

import { computed, ref } from 'vue';
import { defineComponent, pick, useRender } from "../../util/index.mjs"; // Types

const dirtyTypes = ['color', 'file', 'time', 'date', 'datetime-local', 'week', 'month'];
export const VTextField = defineComponent({
  name: 'VTextField',
  directives: {
    Intersect
  },
  inheritAttrs: false,
  props: {
    autofocus: Boolean,
    counter: [Boolean, Number, String],
    counterValue: Function,
    prefix: String,
    placeholder: String,
    persistentPlaceholder: Boolean,
    suffix: String,
    type: {
      type: String,
      default: 'text'
    },
    modelValue: String,
    ...makeVFieldProps()
  },
  emits: {
    'update:modelValue': val => true
  },

  setup(props, {
    attrs,
    emit,
    slots
  }) {
    const model = useProxiedModel(props, 'modelValue');
    const internalDirty = ref(false);
    const isDirty = computed(() => {
      return internalDirty.value || !!model.value || dirtyTypes.includes(props.type);
    });
    const counterValue = computed(() => {
      var _model$value;

      return typeof props.counterValue === 'function' ? props.counterValue(model.value) : (_model$value = model.value) == null ? void 0 : _model$value.toString().length;
    });

    function onIntersect(isIntersecting, entries) {
      var _entries$0$target, _entries$0$target$foc;

      if (!props.autofocus || !isIntersecting) return;
      (_entries$0$target = entries[0].target) == null ? void 0 : (_entries$0$target$foc = _entries$0$target.focus) == null ? void 0 : _entries$0$target$foc.call(_entries$0$target);
    }

    const fieldRef = ref();

    function focus() {
      var _fieldRef$value, _fieldRef$value$input;

      (_fieldRef$value = fieldRef.value) == null ? void 0 : (_fieldRef$value$input = _fieldRef$value.inputRef) == null ? void 0 : _fieldRef$value$input.focus();
    }

    function blur() {
      var _fieldRef$value2, _fieldRef$value2$inpu;

      (_fieldRef$value2 = fieldRef.value) == null ? void 0 : (_fieldRef$value2$inpu = _fieldRef$value2.inputRef) == null ? void 0 : _fieldRef$value2$inpu.blur();
    }

    useRender(() => {
      const hasCounter = slots.counter || props.counter || props.counterValue;
      const [_, restAttrs] = pick(attrs, ['class']);
      return _createVNode(VField, _mergeProps({
        "ref": fieldRef,
        "class": ['v-text-field', {
          'v-text-field--prefixed': props.prefix,
          'v-text-field--suffixed': props.suffix
        }, attrs.class],
        "active": isDirty.value,
        "onUpdate:active": val => internalDirty.value = val,
        "onClick:control": focus,
        "onClick:clear": e => {
          e.stopPropagation();
          model.value = '';
        },
        "role": "textbox"
      }, attrs, props), { ...slots,
        default: ({
          isActive,
          inputRef,
          props: {
            class: fieldClass,
            ...slotProps
          }
        }) => {
          const showPlaceholder = isActive || props.persistentPlaceholder;
          return _createVNode(_Fragment, null, [props.prefix && _createVNode("span", {
            "class": "v-text-field__prefix",
            "style": {
              opacity: showPlaceholder ? undefined : '0'
            }
          }, [props.prefix], 4), _withDirectives(_createVNode("input", _mergeProps({
            "class": fieldClass,
            "style": {
              opacity: showPlaceholder ? undefined : '0'
            },
            "onUpdate:modelValue": $event => model.value = $event,
            "ref": inputRef,
            "autofocus": props.autofocus,
            "disabled": props.disabled,
            "placeholder": props.placeholder,
            "size": 1,
            "type": props.type
          }, slotProps, restAttrs), null, 16, ["onUpdate:modelValue", "autofocus", "disabled", "placeholder", "type"]), [[_vModelDynamic, model.value], [_resolveDirective("intersect"), {
            handler: onIntersect
          }, null, {
            once: true
          }]]), props.suffix && _createVNode("span", {
            "class": "v-text-field__suffix",
            "style": {
              opacity: showPlaceholder ? undefined : '0'
            }
          }, [props.suffix], 4)]);
        },
        details: hasCounter ? () => _createVNode(_Fragment, null, [_createVNode("span", null, null), _createVNode(VCounter, {
          "value": counterValue.value,
          "max": attrs.maxlength
        }, slots.counter, 8, ["value", "max"])]) : undefined
      }, 16, ["class", "active", "onUpdate:active", "onClick:control", "onClick:clear"]);
    });
    return {
      fieldRef,
      focus,
      blur
    };
  }

});
//# sourceMappingURL=VTextField.mjs.map