// Utilities
import { computed, getCurrentInstance, ref } from 'vue';
import { consoleError, toKebabCase } from "../util/index.mjs"; // Types

// Composables
export function useProxiedModel(props, prop, defaultValue, transformIn = v => v, transformOut = v => v) {
  const vm = getCurrentInstance();
  if (!vm) consoleError('useProxiedModel must be called from inside a setup function');
  const propIsDefined = computed(() => {
    var _vm$vnode$props, _vm$vnode$props2;

    return !!(typeof props[prop] !== 'undefined' && (vm != null && (_vm$vnode$props = vm.vnode.props) != null && _vm$vnode$props.hasOwnProperty(prop) || vm != null && (_vm$vnode$props2 = vm.vnode.props) != null && _vm$vnode$props2.hasOwnProperty(toKebabCase(prop))));
  });
  const internal = ref(transformIn(props[prop]));
  return computed({
    get() {
      if (propIsDefined.value) return transformIn(props[prop]);else return internal.value;
    },

    set(newValue) {
      internal.value = newValue;
      vm == null ? void 0 : vm.emit(`update:${prop}`, transformOut(newValue));
    }

  });
}
//# sourceMappingURL=proxiedModel.mjs.map