import { camelize, capitalize, h } from 'vue';
import { defineComponent } from "./defineComponent.mjs";
export function createSimpleFunctional(klass, tag = 'div', name) {
  return defineComponent({
    name: name != null ? name : capitalize(camelize(klass.replace(/__/g, '-'))),
    props: {
      tag: {
        type: String,
        default: tag
      }
    },

    setup(props, {
      slots
    }) {
      return () => {
        var _slots$default;

        return h(props.tag, {
          class: klass
        }, (_slots$default = slots.default) == null ? void 0 : _slots$default.call(slots));
      };
    }

  });
}
//# sourceMappingURL=createSimpleFunctional.mjs.map