/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.gcm.server;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.RetryExecutor;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.util.EntityUtils;
import org.whispersystems.gcm.server.AuthenticationFailedException;
import org.whispersystems.gcm.server.InvalidRequestException;
import org.whispersystems.gcm.server.Message;
import org.whispersystems.gcm.server.Result;
import org.whispersystems.gcm.server.ServerFailedException;
import org.whispersystems.gcm.server.internal.GcmResponseEntity;
import org.whispersystems.gcm.server.internal.GcmResponseListEntity;

public class Sender {
    private static final String PRODUCTION_URL = "https://android.googleapis.com/gcm/send";
    private final CloseableHttpAsyncClient client;
    private final String authorizationHeader;
    private final RetryExecutor executor;
    private final String url;

    public Sender(String apiKey) {
        this(apiKey, 10);
    }

    public Sender(String apiKey, int retryCount) {
        this(apiKey, retryCount, PRODUCTION_URL);
    }

    @VisibleForTesting
    public Sender(String apiKey, int retryCount, String url) {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        this.url = url;
        this.authorizationHeader = String.format("key=%s", apiKey);
        this.client = HttpAsyncClients.custom().setMaxConnTotal(100).setMaxConnPerRoute(10).build();
        this.executor = new AsyncRetryExecutor(scheduler).retryOn(new Class[]{ServerFailedException.class}).retryOn(new Class[]{TimeoutException.class}).retryOn(new Class[]{IOException.class}).withExponentialBackoff(100L, 2.0).withUniformJitter().withMaxDelay(4000L).withMaxRetries(retryCount);
        this.client.start();
    }

    public ListenableFuture<Result> send(Message message) {
        return this.send(message, null);
    }

    public ListenableFuture<Result> send(final Message message, final Object requestContext) {
        return this.executor.getFutureWithRetry((RetryCallable)new RetryCallable<ListenableFuture<Result>>(){

            public ListenableFuture<Result> call(RetryContext context) throws Exception {
                SettableFuture future = SettableFuture.create();
                HttpPost request = new HttpPost(Sender.this.url);
                request.setHeader("Authorization", Sender.this.authorizationHeader);
                request.setEntity((HttpEntity)new StringEntity(message.serialize(), ContentType.parse((String)"application/json")));
                Sender.this.client.execute((HttpUriRequest)request, (FutureCallback)new ResponseHandler((SettableFuture<Result>)future, requestContext));
                return future;
            }
        });
    }

    public void stop() throws IOException {
        this.client.close();
    }

    private static final class ResponseHandler
    implements FutureCallback<HttpResponse> {
        private static final ObjectMapper objectMapper = new ObjectMapper();
        private final SettableFuture<Result> future;
        private final Object requestContext;

        public ResponseHandler(SettableFuture<Result> future, Object requestContext) {
            this.future = future;
            this.requestContext = requestContext;
        }

        public void completed(HttpResponse result) {
            try {
                String responseBody = EntityUtils.toString((HttpEntity)result.getEntity());
                switch (result.getStatusLine().getStatusCode()) {
                    case 400: {
                        this.future.setException((Throwable)new InvalidRequestException());
                        break;
                    }
                    case 401: {
                        this.future.setException((Throwable)new AuthenticationFailedException());
                        break;
                    }
                    case 200: 
                    case 204: {
                        this.future.set((Object)this.parseResult(responseBody));
                        break;
                    }
                    default: {
                        this.future.setException((Throwable)new ServerFailedException("Bad status: " + result.getStatusLine().getStatusCode()));
                        break;
                    }
                }
            }
            catch (IOException e) {
                this.future.setException((Throwable)e);
            }
        }

        public void failed(Exception ex) {
            this.future.setException((Throwable)ex);
        }

        public void cancelled() {
            this.future.setException((Throwable)new ServerFailedException("Canceled!"));
        }

        private Result parseResult(String body) throws IOException {
            List<GcmResponseEntity> responseList = ((GcmResponseListEntity)objectMapper.readValue(body, GcmResponseListEntity.class)).getResults();
            if (responseList == null || responseList.size() == 0) {
                throw new IOException("Empty response list!");
            }
            GcmResponseEntity responseEntity = responseList.get(0);
            return new Result(this.requestContext, responseEntity.getCanonicalRegistrationId(), responseEntity.getMessageId(), responseEntity.getError());
        }

        static {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }
    }
}

