/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.openlayers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.openlayers.IOpenLayersMap;
import org.wicketstuff.openlayers.OpenLayersMapHeaderContributor;
import org.wicketstuff.openlayers.api.Bounds;
import org.wicketstuff.openlayers.api.IJavascriptComponent;
import org.wicketstuff.openlayers.api.InfoWindow;
import org.wicketstuff.openlayers.api.LonLat;
import org.wicketstuff.openlayers.api.Marker;
import org.wicketstuff.openlayers.api.Overlay;
import org.wicketstuff.openlayers.api.layer.GMap;
import org.wicketstuff.openlayers.api.layer.Layer;
import org.wicketstuff.openlayers.api.layer.OSM;
import org.wicketstuff.openlayers.api.layer.Vector;
import org.wicketstuff.openlayers.api.layer.WFS;
import org.wicketstuff.openlayers.api.layer.WMS;
import org.wicketstuff.openlayers.event.EventType;
import org.wicketstuff.openlayers.event.OverlayListenerBehavior;
import org.wicketstuff.openlayers.event.PopupListener;
import org.wicketstuff.openlayers.js.JSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLayersMap
extends Panel
implements IOpenLayersMap {
    private static final String OPEN_LAYERS_VERSION = "2.9.1";
    private static Logger log = LoggerFactory.getLogger(OpenLayersMap.class);
    private String businessLogicProjection = null;
    private static final long serialVersionUID = 1L;
    private Bounds bounds;
    private PopupListener callbackListener = null;
    private static final LonLat DEFAULT_CENTER = new LonLat(37.4419, -122.1419);
    private LonLat center = DEFAULT_CENTER;
    private List<IJavascriptComponent> controls = new ArrayList<IJavascriptComponent>();
    private boolean externalControls = false;
    private InfoWindow infoWindow;
    private List<Layer> layers = new ArrayList<Layer>();
    private final WebMarkupContainer map;
    private HashMap<String, String> options = new HashMap();
    private List<Overlay> overlays = new ArrayList<Overlay>();
    private static final Integer DEFAULT_ZOOM = 13;
    private Integer zoom = DEFAULT_ZOOM;
    private boolean showMarkersInLayerSwitcher = true;

    public OpenLayersMap(String id, boolean developmentMode) {
        this(id, new OpenLayersMapHeaderContributor(developmentMode, OPEN_LAYERS_VERSION), new ArrayList<Overlay>(), new ArrayList<Layer>(), new HashMap<String, String>());
        HashMap<String, String> layerOptions = new HashMap<String, String>();
        layerOptions.put("layers", JSUtils.getQuotedString("basic"));
        this.layers.add(new WMS("OpenLayers WMS", "http://labs.metacarta.com/wms/vmap0", layerOptions));
    }

    public OpenLayersMap(String id) {
        this(id, false);
    }

    public OpenLayersMap(String id, boolean developmentMode, List<Layer> defaultLayers, HashMap<String, String> options) {
        this(id, new OpenLayersMapHeaderContributor(developmentMode, OPEN_LAYERS_VERSION), new ArrayList<Overlay>(), defaultLayers, options);
    }

    public OpenLayersMap(String id, List<Layer> defaultLayers, HashMap<String, String> options) {
        this(id, false, defaultLayers, options);
    }

    public OpenLayersMap(String id, boolean developmentMode, List<Layer> defaultLayers, HashMap<String, String> options, List<Overlay> overlays) {
        this(id, new OpenLayersMapHeaderContributor(developmentMode, OPEN_LAYERS_VERSION), overlays, defaultLayers, options);
    }

    public OpenLayersMap(String id, List<Layer> defaultLayers, HashMap<String, String> options, List<Overlay> overlays) {
        this(id, false, defaultLayers, options, overlays);
    }

    public OpenLayersMap(String id, List<Layer> defaultLayers, HashMap<String, String> options, List<Overlay> overlays, PopupListener popupListener) {
        this(id, false, defaultLayers, options, overlays, popupListener);
    }

    public OpenLayersMap(String id, boolean developmentMode, List<Layer> defaultLayers, HashMap<String, String> options, List<Overlay> overlays, PopupListener popupListener) {
        this(id, new OpenLayersMapHeaderContributor(developmentMode, OPEN_LAYERS_VERSION), overlays, popupListener, defaultLayers, options);
    }

    protected OpenLayersMap(String id, HeaderContributor headerContrib, List<Overlay> overlays, List<Layer> defaultLayers, HashMap<String, String> options) {
        this(id, headerContrib, overlays, new PopupListener(false){

            protected void onClick(AjaxRequestTarget target, Overlay overlay) {
                if (Marker.class.isInstance(overlay)) {
                    this.clickAndOpenPopup((Marker)overlay, target);
                }
            }
        }, defaultLayers, options);
    }

    private OpenLayersMap(String id, HeaderContributor headerContrib, List<Overlay> overlays, PopupListener popupListener, List<Layer> defaultLayers, HashMap<String, String> options) {
        super(id);
        popupListener.setOpenLayersMap(this);
        this.overlays = overlays;
        this.layers = defaultLayers;
        this.options = options;
        this.callbackListener = popupListener;
        this.add(new IBehavior[]{this.callbackListener});
        this.add(new IBehavior[]{headerContrib});
        this.addHeaderContributorsForLayers(this.layers);
        this.add(new IBehavior[]{new HeaderContributor(new IHeaderContributor(){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.renderOnDomReadyJavascript(OpenLayersMap.this.getJSinit());
            }
        })});
        this.setInfoWindow(new InfoWindow());
        this.add(new Component[]{this.getInfoWindow()});
        this.map = new WebMarkupContainer("map");
        this.map.setOutputMarkupId(true);
        this.add(new Component[]{this.map});
    }

    private void addHeaderContributorsForLayers(List<Layer> layers) {
        for (Layer layer : layers) {
            for (HeaderContributor contributor : layer.getHeaderContributors()) {
                this.add(new IBehavior[]{contributor});
            }
        }
    }

    @Override
    public OpenLayersMap addControl(IJavascriptComponent control) {
        AjaxRequestTarget target;
        this.controls.add(control);
        JavascriptResourceReference[] jsReferences = control.getJSResourceReferences();
        if (jsReferences != null && jsReferences.length > 0) {
            for (int i = 0; i < jsReferences.length; ++i) {
                JavascriptResourceReference javascriptResourceReference = jsReferences[i];
                this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)javascriptResourceReference)});
            }
        }
        if ((target = AjaxRequestTarget.get()) != null && this.findPage() != null) {
            target.appendJavascript(control.getJSadd(this));
            if (jsReferences != null && jsReferences.length > 0) {
                for (int i = 0; i < jsReferences.length; ++i) {
                    JavascriptResourceReference javascriptResourceReference = jsReferences[i];
                    target.getHeaderResponse().renderJavascriptReference((ResourceReference)javascriptResourceReference);
                }
            }
        }
        return this;
    }

    @Override
    public OpenLayersMap addOverlay(Overlay overlay) {
        this.overlays.add(overlay);
        for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
            this.add(new IBehavior[]{behavior});
        }
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            String jsToRun = this.getJsOverlay(overlay);
            AjaxRequestTarget.get().appendJavascript(jsToRun);
        }
        return this;
    }

    @Override
    public OpenLayersMap clearOverlays() {
        for (Overlay overlay : this.overlays) {
            for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
                this.remove((IBehavior)behavior);
            }
        }
        this.overlays.clear();
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavascript(this.getJSinvoke("clearOverlays()"));
        }
        return this;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    public PopupListener getCallbackListener() {
        return this.callbackListener;
    }

    @Override
    public LonLat getCenter() {
        return this.center;
    }

    @Override
    public List<IJavascriptComponent> getControls() {
        return this.controls;
    }

    protected String getJSinit() {
        StringBuffer js = new StringBuffer();
        if (this.options.size() > 0) {
            js.append("\nvar options = {");
            boolean first = true;
            for (String key : this.options.keySet()) {
                if (first) {
                    first = false;
                } else {
                    js.append(",\n");
                }
                js.append(key + ":" + this.options.get(key));
            }
            js.append("};\n");
            js.append("new WicketOMap('" + this.map.getMarkupId() + "', options, null, " + String.valueOf(this.showMarkersInLayerSwitcher) + ");\n");
        } else {
            js.append("new WicketOMap('" + this.map.getMarkupId() + "', null, null, " + String.valueOf(this.showMarkersInLayerSwitcher) + ");\n");
        }
        for (Layer layer : this.layers) {
            if (layer instanceof WMS) {
                WMS wms = (WMS)layer;
                js.append("var wms" + wms.getId() + " =" + wms.getJSconstructor() + ";\n");
                js.append(this.getJSinvoke("addLayer(wms" + wms.getId() + "," + wms.getId() + ")"));
            }
            if (layer instanceof GMap) {
                GMap gmap = (GMap)layer;
                js.append("var gmap" + gmap.getId() + " =" + gmap.getJSconstructor() + ";\n");
                js.append(this.getJSinvoke("addLayer(gmap" + gmap.getId() + "," + gmap.getId() + ")"));
            }
            if (layer instanceof OSM) {
                OSM osm = (OSM)layer;
                js.append("var osm" + osm.getId() + " =" + osm.getJSconstructor() + ";\n");
                js.append(this.getJSinvoke("addLayer(osm" + osm.getId() + "," + osm.getId() + ")"));
            }
            if (layer instanceof WFS) {
                WFS wfs = (WFS)layer;
                js.append("var wfs" + wfs.getId() + " =" + wfs.getJSconstructor() + ";\n");
                js.append(this.getJSinvoke("addLayer(wfs" + wfs.getId() + "," + wfs.getId() + ")"));
            }
            if (!(layer instanceof Vector)) continue;
            Vector vec = (Vector)layer;
            js.append("var vec" + vec.getId() + " =" + vec.getJSconstructor() + ";\n");
            js.append(this.getJSinvoke("addLayer(vec" + vec.getId() + "," + vec.getId() + ")"));
        }
        if (!this.zoom.equals(DEFAULT_ZOOM)) {
            if (!this.center.equals(DEFAULT_CENTER)) {
                js.append(this.getJSsetCenter(this.center, this.zoom));
            } else {
                js.append(this.getJSsetZoom(this.zoom));
            }
        } else {
            js.append(this.getJSinvoke("zoomToMaxExtent()"));
        }
        for (IJavascriptComponent control : this.controls) {
            js.append(control.getJSadd(this));
        }
        for (Overlay overlay : this.overlays) {
            js.append(this.getJsOverlay(overlay));
        }
        js.append(this.getJSinvoke("setPopupId('" + this.getInfoWindow().getContent().getMarkupId() + "')"));
        if (this.businessLogicProjection != null) {
            js.append(this.getJSSetBusinessLogicProjection());
        }
        return js.toString();
    }

    @Override
    public String getJSInstance() {
        return "Wicket.omaps['" + this.map.getMarkupId() + "']";
    }

    @Override
    public String getJSinvoke(String invocation) {
        return "Wicket.omaps['" + this.map.getMarkupId() + "']." + invocation + ";\n";
    }

    @Override
    public String getJSinvokeNoLineEnd(String invocation) {
        return "Wicket.omaps['" + this.map.getMarkupId() + "']." + invocation;
    }

    private String getJsOverlay(Overlay overlay) {
        String jsToRun = overlay.getJSadd(this) + "\n";
        if (overlay instanceof Marker) {
            Marker marker = (Marker)overlay;
            if (marker.getPopup() != null && (marker.getEvents() == null || marker.getEvents().length == 0)) {
                marker.addEvent(EventType.mousedown);
            }
            for (EventType evt : marker.getEvents()) {
                jsToRun = jsToRun + this.getJSinvoke("addMarkerListener('" + evt.name() + "','" + this.callbackListener.getCallBackForMarker(marker) + "'," + marker.getOverlayJSVar() + ")");
            }
            if (marker.getIcon() != null) {
                jsToRun = marker.getIcon().getSize().getJSadd() + marker.getIcon().getOffset().getJSadd() + marker.getIcon().getJSadd() + jsToRun;
            }
        }
        return jsToRun;
    }

    private String getJSpanDirection(int dx, int dy) {
        return this.getJSinvoke("panDirection(" + dx + "," + dy + ")");
    }

    private String getJSsetCenter(LonLat center, Integer zoom) {
        if (center != null && zoom != null) {
            return this.getJSinvoke("setCenter(" + center.getJSconstructor() + ", " + zoom + ")");
        }
        return "";
    }

    private String getJSsetDoubleClickZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setDoubleClickZoomEnabled(" + enabled + ")");
    }

    private String getJSsetDraggingEnabled(boolean enabled) {
        return this.getJSinvoke("setDraggingEnabled(" + enabled + ")");
    }

    private String getJSsetScrollWheelZoomEnabled(boolean enabled) {
        return this.getJSinvoke("setScrollWheelZoomEnabled(" + enabled + ")");
    }

    private String getJSsetZoom(Integer zoom) {
        return zoom != null ? this.getJSinvoke("setZoom(" + zoom + ")") : "";
    }

    private String getJSzoomIn() {
        return this.getJSinvoke("zoomIn()");
    }

    private String getJSzoomOut() {
        return this.getJSinvoke("zoomOut()");
    }

    @Override
    public List<Layer> getLayers() {
        return this.layers;
    }

    @Override
    public List<Overlay> getOverlays() {
        return Collections.unmodifiableList(this.overlays);
    }

    @Override
    public Integer getZoom() {
        return this.zoom;
    }

    @Override
    public boolean isExternalControls() {
        return this.externalControls;
    }

    @Override
    public OpenLayersMap removeControl(IJavascriptComponent control) {
        this.controls.remove(control);
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavascript(control.getJSremove(this));
        }
        return this;
    }

    @Override
    public OpenLayersMap removeOverlay(Overlay overlay) {
        while (this.overlays.contains(overlay)) {
            this.overlays.remove(overlay);
        }
        for (OverlayListenerBehavior behavior : overlay.getBehaviors()) {
            this.remove((IBehavior)behavior);
        }
        if (AjaxRequestTarget.get() != null && this.findPage() != null) {
            AjaxRequestTarget.get().appendJavascript(overlay.getJSremove(this));
        }
        return this;
    }

    @Override
    public void setCenter(LonLat center, Integer zoom) {
        if (!this.center.equals(center)) {
            this.center = center;
            this.zoom = zoom;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavascript(this.getJSsetCenter(center, zoom));
            }
        }
    }

    @Override
    public void setExternalControls(boolean externalControls) {
        this.externalControls = externalControls;
    }

    @Override
    public void setLayers(List<Layer> layers) {
        this.layers = layers;
    }

    @Override
    public void setOverlays(List<Overlay> overlays) {
        this.clearOverlays();
        for (Overlay overlay : overlays) {
            this.addOverlay(overlay);
        }
    }

    @Override
    public void setZoom(Integer level) {
        if (this.zoom != level) {
            this.zoom = level;
            if (AjaxRequestTarget.get() != null && this.findPage() != null) {
                AjaxRequestTarget.get().appendJavascript(this.getJSsetZoom(this.zoom));
            }
        }
    }

    @Override
    public void update(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        this.center = LonLat.parseWithNames(request.getParameter("centerConverted"));
        this.zoom = Integer.parseInt(request.getParameter("zoomConverted"));
        this.bounds = Bounds.parseWithNames(request.getParameter("boundsConverted"));
        this.getInfoWindow().update(target);
    }

    public void setInfoWindow(InfoWindow infoWindow) {
        this.infoWindow = infoWindow;
    }

    public InfoWindow getInfoWindow() {
        return this.infoWindow;
    }

    protected void onRender(MarkupStream markupStream) {
        super.onRender(markupStream);
        if ("development".equalsIgnoreCase(Application.get().getConfigurationType()) && !Application.get().getMarkupSettings().getStripWicketTags()) {
            log.warn("Application is in DEVELOPMENT mode && Wicket tags are not stripped, Firefox 3.0 will not render the OMap. Change to DEPLOYMENT mode  || turn on Wicket tags stripping. See: http://www.nabble.com/Gmap2-problem-with-Firefox-3.0-to18137475.html.");
        }
    }

    @Override
    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public void setCenter(LonLat center) {
        this.setCenter(center, this.zoom);
    }

    public void setShowMarkersInLayerSwitcher(boolean showMarkersInLayerSwitcher) {
        this.showMarkersInLayerSwitcher = showMarkersInLayerSwitcher;
    }

    @Override
    public void setBusinessLogicProjection(String businessLogicProjection) {
        this.businessLogicProjection = businessLogicProjection;
        if (AjaxRequestTarget.get() != null) {
            AjaxRequestTarget.get().appendJavascript(this.getJSSetBusinessLogicProjection());
        }
    }

    @Override
    public String getBusinessLogicProjection() {
        return this.businessLogicProjection;
    }

    private String getJSSetBusinessLogicProjection() {
        if (this.businessLogicProjection == null) {
            return this.getJSinvoke("setBusinessLogicProjection(null)");
        }
        return this.getJSinvoke("setBusinessLogicProjection('" + this.businessLogicProjection + "')");
    }

    public class ZoomOutBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomOutBehavior(String event) {
            super(event);
        }

        protected String getJSinvoke() {
            return OpenLayersMap.this.getJSzoomOut();
        }
    }

    public class ZoomInBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;

        public ZoomInBehavior(String event) {
            super(event);
        }

        protected String getJSinvoke() {
            return OpenLayersMap.this.getJSzoomIn();
        }
    }

    public class SetZoomBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private Integer zoom;

        public SetZoomBehavior(String event, Integer zoom) {
            super(event);
            this.zoom = zoom;
        }

        protected String getJSinvoke() {
            return OpenLayersMap.this.getJSsetZoom(this.zoom);
        }
    }

    public class SetCenterBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private LonLat gLatLng;
        private Integer zoom;

        public SetCenterBehavior(String event, LonLat gLatLng, Integer zoom) {
            super(event);
            this.gLatLng = gLatLng;
            this.zoom = zoom;
        }

        protected String getJSinvoke() {
            return OpenLayersMap.this.getJSsetCenter(this.gLatLng, this.zoom);
        }
    }

    public class PanDirectionBehavior
    extends JSMethodBehavior {
        private static final long serialVersionUID = 1L;
        private int dx;
        private int dy;

        public PanDirectionBehavior(String event, int dx, int dy) {
            super(event);
            this.dx = dx;
            this.dy = dy;
        }

        protected String getJSinvoke() {
            return OpenLayersMap.this.getJSpanDirection(this.dx, this.dy);
        }
    }

    private abstract class JSMethodBehavior
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;
        private String attribute;

        public JSMethodBehavior(String attribute) {
            this.attribute = attribute;
        }

        protected abstract String getJSinvoke();

        public void onComponentTag(Component component, ComponentTag tag) {
            String invoke = this.getJSinvoke();
            if (this.attribute.equalsIgnoreCase("href")) {
                invoke = "javascript:" + invoke;
            }
            tag.put(this.attribute, (CharSequence)invoke);
        }
    }
}

