/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONStringer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;
import org.wicketstuff.select2.AjaxSettings;
import org.wicketstuff.select2.ChoiceProvider;
import org.wicketstuff.select2.JQuery;
import org.wicketstuff.select2.Response;
import org.wicketstuff.select2.Select2LanguageResourceReference;
import org.wicketstuff.select2.Select2ResourcesBehavior;
import org.wicketstuff.select2.Settings;

public abstract class AbstractSelect2Choice<T, M>
extends AbstractTextComponent<M>
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private final Settings settings = new Settings();
    private ChoiceProvider<T> provider;
    private boolean convertInputPerformed = false;

    public AbstractSelect2Choice(String id) {
        this(id, null, null);
    }

    public AbstractSelect2Choice(String id, IModel<M> model) {
        this(id, model, null);
    }

    public AbstractSelect2Choice(String id, ChoiceProvider<T> provider) {
        this(id, null, provider);
    }

    public AbstractSelect2Choice(String id, IModel<M> model, ChoiceProvider<T> provider) {
        super(id, model);
        this.provider = provider;
        this.add(new Behavior[]{new Select2ResourcesBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                if (AbstractSelect2Choice.this.settings.getTheme() != null) {
                    AbstractSelect2Choice.this.settings.getTheme().renderHead(component, response);
                }
                response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new Select2LanguageResourceReference(AbstractSelect2Choice.this.settings.getLanguage())));
            }
        }});
        this.setOutputMarkupId(true);
    }

    public final Settings getSettings() {
        return this.settings;
    }

    public final void setProvider(ChoiceProvider<T> provider) {
        this.provider = provider;
    }

    public final ChoiceProvider<T> getProvider() {
        if (this.provider == null) {
            throw new IllegalStateException("Select2 choice component: " + this.getId() + " does not have a ChoiceProvider set");
        }
        return this.provider;
    }

    public final void convertInput() {
        String[] inputAsArray = this.getInputAsArray();
        Object convertedInput = this.convertValue(inputAsArray);
        this.setConvertedInput(convertedInput);
        this.convertInputPerformed = true;
    }

    protected final Collection<T> convertIdsToChoices(List<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        return this.getProvider().toChoices(ids);
    }

    protected String getJquerySafeMarkupId() {
        return this.getMarkupId().replace(".", "\\\\.");
    }

    protected String getEscapedJsString(String key) {
        String value = this.getString(key);
        return Strings.replaceAll((CharSequence)value, (CharSequence)"'", (CharSequence)"\\'").toString();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2(%s);", this.getJquerySafeMarkupId(), this.getSettings().toJson())));
    }

    protected final M getCurrentValue() {
        if (this.hasRawInput()) {
            if (this.convertInputPerformed) {
                return (M)this.getConvertedInput();
            }
            String raw = this.getRawInput();
            Object result = null;
            if (raw != null) {
                String[] values = raw.split(";");
                result = this.convertValue(values);
            }
            return (M)result;
        }
        return (M)this.getModelObject();
    }

    protected void onInitialize() {
        super.onInitialize();
        if (this.isAjax() && !this.settings.isStateless()) {
            AjaxSettings ajax = this.getSettings().getAjax(true);
            ajax.setData(String.format("function(params) { return { '%s': params.term, page: params.page, '%s':true, '%s':[window.location.protocol, '//', window.location.host, window.location.pathname].join('')}; }", this.settings.getQueryParam(), "wicket-ajax", "wicket-ajax-baseurl"));
            ajax.setProcessResults("function(data, page) { return { results: data.items, pagination: { more: data.more } };  }");
        } else if (this.settings.isStateless()) {
            AjaxSettings ajax = this.getSettings().getAjax(true);
            ajax.setProcessResults("function(data, page) { return { results: data.items, pagination: { more: data.more } };  }");
        }
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.getSettings().isStateless()) {
            if (Strings.isEmpty((CharSequence)this.getSettings().getMountPath())) {
                throw new IllegalStateException("Select2 in stateless mode should specify a mountPath");
            }
            this.getSettings().getAjax(true).setUrl(this.getSettings().getMountPath());
        } else if (this.isAjax()) {
            this.getSettings().getAjax(true).setUrl(this.urlFor(IResourceListener.INTERFACE, null));
        }
    }

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target;
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxRequestTarget && (target = (AjaxRequestTarget)event.getPayload()).getComponents().contains((Object)this)) {
            target.prependJavaScript((CharSequence)JQuery.execute("$('#%s').select2('destroy');", this.getJquerySafeMarkupId()));
        }
    }

    protected boolean getStatelessHint() {
        if (this.settings.isStateless()) {
            return true;
        }
        return !this.isAjax();
    }

    public boolean isAjax() {
        return this.provider != null;
    }

    public static <T> void generateJSON(ChoiceProvider<T> provider, OutputStream outputStream) {
        AbstractSelect2Choice.generateJSON("q", provider, outputStream);
    }

    public static <T> void generateJSON(String queryParam, ChoiceProvider<T> provider, OutputStream outputStream) {
        Request request = RequestCycle.get().getRequest();
        IRequestParameters params = request.getRequestParameters();
        String term = params.getParameterValue(queryParam).toOptionalString();
        int page = params.getParameterValue("page").toInt(1);
        Response response = new Response();
        provider.query(term, --page, response);
        JSONStringer json = new JSONStringer();
        try {
            json.object();
            json.key("items").array();
            for (Object item : response) {
                json.object();
                provider.toJson(item, json);
                json.endObject();
            }
            json.endArray();
            json.key("more").value((Object)response.getHasMore()).endObject();
        }
        catch (JSONException e) {
            throw new RuntimeException("Could not write Json response", e);
        }
        try (OutputStreamWriter out = new OutputStreamWriter(outputStream, request.getCharset());){
            out.append(json.toString());
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write Json to servlet response", e);
        }
    }

    public void onResourceRequested() {
        WebResponse webResponse = (WebResponse)this.getRequestCycle().getResponse();
        webResponse.setContentType("application/json");
        AbstractSelect2Choice.generateJSON(this.settings.getQueryParam(), this.provider, webResponse.getOutputStream());
    }

    protected void onDetach() {
        this.convertInputPerformed = false;
        if (this.isAjax()) {
            this.getProvider().detach();
        }
        super.onDetach();
    }

    private void addOption(T choice, AppendingStringBuffer buffer) {
        buffer.append("<option selected=\"selected\" value=\"").append((Object)Strings.escapeMarkup((CharSequence)this.getProvider().getIdValue(choice))).append("\">").append((Object)Strings.escapeMarkup((CharSequence)this.getProvider().getDisplayValue(choice))).append("</option>");
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "select");
        super.onComponentTag(tag);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        AppendingStringBuffer buffer = new AppendingStringBuffer();
        M currentValue = this.getCurrentValue();
        if (currentValue instanceof Collection) {
            Collection choices = (Collection)currentValue;
            for (Object choice : choices) {
                this.addOption(choice, buffer);
            }
        } else if (currentValue != null) {
            M choice = currentValue;
            this.addOption(choice, buffer);
        }
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    public boolean isInputNullable() {
        return true;
    }
}

