/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.select2;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class ApplicationSettings {
    private static final MetaDataKey<ApplicationSettings> KEY = new MetaDataKey<ApplicationSettings>(){
        private static final long serialVersionUID = 1L;
    };
    private ResourceReference javaScriptReference = new JavaScriptResourceReference(ApplicationSettings.class, "res/js/select2.js");
    private ResourceReference javaScriptReferenceFull = new JavaScriptResourceReference(ApplicationSettings.class, "res/js/select2.full.js");
    private ResourceReference cssReference = new CssResourceReference(ApplicationSettings.class, "res/css/select2.css");
    private boolean includeJavascriptFull = true;
    private boolean includeJavascript = false;
    private boolean includeCss = true;

    private ApplicationSettings() {
    }

    public boolean isIncludeJavascript() {
        return this.includeJavascript;
    }

    public ApplicationSettings setIncludeJavascript(boolean includeJavascript) {
        this.includeJavascript = includeJavascript;
        if (this.includeJavascript) {
            this.includeJavascriptFull = false;
        }
        return this;
    }

    public boolean isIncludeCss() {
        return this.includeCss;
    }

    public ApplicationSettings setIncludeCss(boolean includeCss) {
        this.includeCss = includeCss;
        return this;
    }

    public ResourceReference getJavaScriptReference() {
        return this.javaScriptReference;
    }

    public ApplicationSettings setJavaScriptReference(ResourceReference javaScriptReference) {
        this.javaScriptReference = javaScriptReference;
        return this;
    }

    public ResourceReference getCssReference() {
        return this.cssReference;
    }

    public ApplicationSettings setCssReference(ResourceReference cssReference) {
        this.cssReference = cssReference;
        return this;
    }

    public boolean isIncludeJavascriptFull() {
        return this.includeJavascriptFull;
    }

    public ApplicationSettings setIncludeJavascriptFull(boolean includeJavascriptFull) {
        this.includeJavascriptFull = includeJavascriptFull;
        if (this.includeJavascriptFull) {
            this.includeJavascript = false;
        }
        return this;
    }

    public ResourceReference getJavaScriptReferenceFull() {
        return this.javaScriptReferenceFull;
    }

    public ApplicationSettings setJavascriptReferenceFull(ResourceReference javaScriptReferenceFull) {
        this.javaScriptReferenceFull = javaScriptReferenceFull;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationSettings get() {
        Application application = Application.get();
        ApplicationSettings settings = (ApplicationSettings)application.getMetaData(KEY);
        if (settings == null) {
            Application application2 = application;
            synchronized (application2) {
                settings = (ApplicationSettings)application.getMetaData(KEY);
                if (settings == null) {
                    settings = new ApplicationSettings();
                    application.setMetaData(KEY, (Object)settings);
                }
            }
        }
        return (ApplicationSettings)application.getMetaData(KEY);
    }
}

