/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.highlight.scanner;

import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.aesh.extensions.highlight.Encoder;
import org.aesh.extensions.highlight.Scanner;
import org.aesh.extensions.highlight.StringScanner;
import org.aesh.extensions.highlight.TokenType;

public class JSONScanner
implements Scanner {
    public static final Pattern ESCAPE = Pattern.compile("[bfnrt\\\\\"\\/]");
    public static final Pattern UNICODE_ESCAPE = Pattern.compile("u[a-fA-F0-9]{4}");
    public static final Pattern KEY = Pattern.compile("(?>(?:[^\\\\\"]+|\\\\.)*)\"\\s*:");
    public static final Pattern SPACE = Pattern.compile("\\s+");
    public static final Pattern DOUBLE_QUOTE = Pattern.compile("\"");
    public static final Pattern OPERATOR = Pattern.compile("[:,\\[{\\]}]");
    public static final Pattern BOOLEAN = Pattern.compile("true|false|null");
    public static final Pattern NUMBER = Pattern.compile("-?(?:0|[1-9]\\d*)");
    public static final Pattern FLOAT = Pattern.compile("\\.\\d+(?:[eE][-+]?\\d+)?|[eE][-+]?\\d+");
    public static final Pattern CONTENT = Pattern.compile("[^\\\\\"]+");
    public static final Pattern CONTENT_2 = Pattern.compile("\\\\.", 32);
    public static final Pattern CHAR = Pattern.compile("\\\\(?:" + ESCAPE.pattern() + "|" + UNICODE_ESCAPE.pattern() + ")", 32);
    public static final Pattern END = Pattern.compile("\\\\|$");
    public static final Scanner.Type TYPE = new Scanner.Type("JSON", "\\.(json|template)$");

    @Override
    public Scanner.Type getType() {
        return TYPE;
    }

    @Override
    public void scan(StringScanner source, Encoder encoder, Map<String, Object> options) {
        State state = State.initial;
        while (source.hasMore()) {
            MatchResult m = null;
            switch (state) {
                case initial: {
                    m = source.scan(SPACE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.space);
                        break;
                    }
                    m = source.scan(DOUBLE_QUOTE);
                    if (m != null) {
                        state = source.check(KEY) != null ? State.key : State.string;
                        encoder.beginGroup(TokenType.valueOf(state.name()));
                        encoder.textToken(m.group(), TokenType.delimiter);
                        break;
                    }
                    m = source.scan(OPERATOR);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.operator);
                        break;
                    }
                    m = source.scan(BOOLEAN);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.value);
                        break;
                    }
                    m = source.scan(NUMBER);
                    if (m != null) {
                        String match = m.group();
                        m = source.scan(FLOAT);
                        if (m != null) {
                            match = match + m.group();
                            encoder.textToken(match, TokenType.float_);
                            break;
                        }
                        encoder.textToken(match, TokenType.integer);
                        break;
                    }
                    encoder.textToken(source.next(), TokenType.error);
                    break;
                }
                case key: 
                case string: {
                    m = source.scan(CONTENT);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(DOUBLE_QUOTE);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.delimiter);
                        encoder.endGroup(TokenType.valueOf(state.name()));
                        state = State.initial;
                        break;
                    }
                    m = source.scan(CHAR);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.char_);
                        break;
                    }
                    m = source.scan(CONTENT_2);
                    if (m != null) {
                        encoder.textToken(m.group(), TokenType.content);
                        break;
                    }
                    m = source.scan(END);
                    if (m != null) {
                        encoder.endGroup(TokenType.valueOf(state.name()));
                        if (!m.group().isEmpty()) {
                            encoder.textToken(m.group(), TokenType.error);
                        }
                        state = State.initial;
                        break;
                    }
                    throw new RuntimeException("else case \" reached " + source.peek(1) + " not handled");
                }
                default: {
                    throw new RuntimeException("Unknown state " + (Object)((Object)state));
                }
            }
        }
        if (state == State.key || state == State.string) {
            encoder.endGroup(TokenType.valueOf(state.name()));
        }
    }

    public static enum State {
        initial,
        key,
        string;

    }
}

