/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class TimeUnitValidator
extends ModelTypeValidator
implements AllowedValuesValidator {
    public static final TimeUnitValidator ANY_REQUIRED = new TimeUnitValidator(false, false);
    public static final TimeUnitValidator ANY_OPTIONAL = new TimeUnitValidator(true, false);
    private final EnumSet<TimeUnit> allowedValues;

    public TimeUnitValidator(boolean nullable, TimeUnit ... allowed) {
        this(nullable, false, allowed);
    }

    public TimeUnitValidator(boolean nullable, boolean allowExpressions) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.allOf(TimeUnit.class);
    }

    public TimeUnitValidator(boolean nullable, boolean allowExpressions, TimeUnit ... allowed) {
        super(ModelType.STRING, nullable, allowExpressions);
        this.allowedValues = EnumSet.noneOf(TimeUnit.class);
        for (TimeUnit tu : allowed) {
            this.allowedValues.add(tu);
        }
    }

    @Override
    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        String tuString;
        TimeUnit tu;
        super.validateParameter(parameterName, value);
        if (value.isDefined() && ((tu = TimeUnit.valueOf((tuString = value.asString()).toUpperCase(Locale.ENGLISH))) == null || !this.allowedValues.contains((Object)tu))) {
            throw new OperationFailedException(new ModelNode().set(ControllerLogger.ROOT_LOGGER.invalidValue(tuString, parameterName, this.allowedValues)));
        }
    }

    @Override
    public List<ModelNode> getAllowedValues() {
        ArrayList<ModelNode> result = new ArrayList<ModelNode>();
        for (TimeUnit tu : this.allowedValues) {
            result.add(new ModelNode().set(tu.name()));
        }
        return result;
    }
}

