/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.DeferredExtensionContext;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;

public class ExtensionXml {
    private final ModuleLoader moduleLoader;
    private final ExecutorService bootExecutor;
    private final ExtensionRegistry extensionRegistry;
    private final DeferredExtensionContext deferredExtensionContext;

    public ExtensionXml(DeferredExtensionContext deferredExtensionContext) {
        this.deferredExtensionContext = deferredExtensionContext;
        this.moduleLoader = null;
        this.bootExecutor = null;
        this.extensionRegistry = null;
    }

    public ExtensionXml(ModuleLoader loader, ExecutorService executorService, ExtensionRegistry extensionRegistry) {
        this.moduleLoader = loader;
        this.bootExecutor = executorService;
        this.extensionRegistry = extensionRegistry;
        this.deferredExtensionContext = null;
    }

    public void writeExtensions(XMLExtendedStreamWriter writer, ModelNode modelNode) throws XMLStreamException {
        TreeSet keys = new TreeSet(modelNode.keys());
        if (keys.size() > 0) {
            writer.writeStartElement(Element.EXTENSIONS.getLocalName());
            for (String extension : keys) {
                writer.writeEmptyElement(Element.EXTENSION.getLocalName());
                writer.writeAttribute(Attribute.MODULE.getLocalName(), extension);
            }
            writer.writeEndElement();
        }
    }

    public void parseExtensions(XMLExtendedStreamReader reader, ModelNode address, Namespace expectedNs, List<ModelNode> list) throws XMLStreamException {
        DeferredExtensionContext ctx = this.deferredExtensionContext;
        if (ctx == null) {
            ctx = new DeferredExtensionContext(this.moduleLoader, this.extensionRegistry, this.bootExecutor);
        }
        long start = System.currentTimeMillis();
        ParseUtils.requireNoAttributes(reader);
        HashSet<String> found = new HashSet<String>();
        XMLMapper xmlMapper = reader.getXMLMapper();
        while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace(reader, expectedNs);
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.EXTENSION) {
                throw ParseUtils.unexpectedElement(reader);
            }
            String moduleName = ParseUtils.readStringAttributeElement(reader, Attribute.MODULE.getLocalName());
            if (!found.add(moduleName)) {
                throw ControllerLogger.ROOT_LOGGER.duplicateExtensionElement(Element.EXTENSION.getLocalName(), Attribute.MODULE.getLocalName(), moduleName, reader.getLocation());
            }
            ctx.addExtension(moduleName, xmlMapper);
            this.addExtensionAddOperation(address, list, moduleName);
        }
        if (this.deferredExtensionContext == null) {
            ctx.load();
        }
        long elapsed = System.currentTimeMillis() - start;
        if (ControllerLogger.ROOT_LOGGER.isDebugEnabled()) {
            ControllerLogger.ROOT_LOGGER.debugf("Parsed extensions in [%d] ms", elapsed);
        }
    }

    private void addExtensionAddOperation(ModelNode address, List<ModelNode> list, String moduleName) {
        ModelNode add = new ModelNode();
        add.get("address").set(address).add("extension", moduleName);
        add.get("operation").set("add");
        list.add(add);
    }

    @Deprecated
    public static boolean isOrderExtensions() {
        return true;
    }
}

