/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.wildfly.common.Assert;

public class PathAddress
implements Iterable<PathElement> {
    public static final PathAddress EMPTY_ADDRESS = new PathAddress(Collections.emptyList());
    private final List<PathElement> pathAddressList;

    public static PathAddress pathAddress(ModelNode node) {
        if (node.isDefined()) {
            ArrayList<Property> props = new ArrayList<Property>();
            String key = null;
            for (ModelNode element : node.asList()) {
                Property prop = null;
                if (element.getType() == ModelType.PROPERTY || element.getType() == ModelType.OBJECT) {
                    prop = element.asProperty();
                } else if (key == null) {
                    key = element.asString();
                } else {
                    prop = new Property(key, element);
                }
                if (prop == null) continue;
                props.add(prop);
                key = null;
            }
            if (props.isEmpty()) {
                return EMPTY_ADDRESS;
            }
            HashSet<String> seen = new HashSet<String>();
            ArrayList<PathElement> values = new ArrayList<PathElement>();
            int index = 0;
            for (Property prop : props) {
                String name = prop.getName();
                if (!seen.add(name)) {
                    throw PathAddress.duplicateElement(name);
                }
                values.add(new PathElement(name, prop.getValue().asString()));
                if (index == 1 && name.equals("server") && seen.contains("host")) {
                    seen.clear();
                }
                ++index;
            }
            return new PathAddress(Collections.unmodifiableList(values));
        }
        return EMPTY_ADDRESS;
    }

    public static PathAddress pathAddress(List<PathElement> elements) {
        if (elements.isEmpty()) {
            return EMPTY_ADDRESS;
        }
        ArrayList<PathElement> newList = new ArrayList<PathElement>(elements.size());
        HashSet<String> seen = new HashSet<String>();
        int index = 0;
        for (PathElement element : elements) {
            String name = element.getKey();
            if (!seen.add(name)) {
                throw PathAddress.duplicateElement(name);
            }
            newList.add(element);
            if (index == 1 && name.equals("server") && seen.contains("host")) {
                seen.clear();
            }
            ++index;
        }
        return new PathAddress(Collections.unmodifiableList(newList));
    }

    public static PathAddress pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress(Arrays.asList(elements));
    }

    public static PathAddress pathAddress(String key, String value) {
        return PathAddress.pathAddress(PathElement.pathElement(key, value));
    }

    public static PathAddress pathAddress(PathAddress parent, PathElement ... elements) {
        ArrayList<PathElement> list = new ArrayList<PathElement>(parent.pathAddressList);
        for (PathElement element : elements) {
            list.add(element);
        }
        return PathAddress.pathAddress(list);
    }

    public static PathAddress parseCLIStyleAddress(String address) throws IllegalArgumentException {
        PathAddress parsedAddress = EMPTY_ADDRESS;
        if (address == null || address.trim().isEmpty()) {
            return parsedAddress;
        }
        String trimmedAddress = address.trim();
        if (trimmedAddress.charAt(0) != '/' || !Character.isAlphabetic(trimmedAddress.charAt(1))) {
            throw ControllerLogger.ROOT_LOGGER.illegalCLIStylePathAddress(address);
        }
        char[] characters = address.toCharArray();
        boolean escaped = false;
        StringBuilder keyBuffer = new StringBuilder();
        StringBuilder valueBuffer = new StringBuilder();
        StringBuilder currentBuffer = keyBuffer;
        block5: for (int i = 1; i < characters.length; ++i) {
            switch (characters[i]) {
                case '/': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    parsedAddress = PathAddress.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
                    keyBuffer = new StringBuilder();
                    valueBuffer = new StringBuilder();
                    currentBuffer = keyBuffer;
                    continue block5;
                }
                case '\\': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    escaped = true;
                    continue block5;
                }
                case '=': {
                    if (escaped) {
                        escaped = false;
                        currentBuffer.append(characters[i]);
                        continue block5;
                    }
                    currentBuffer = valueBuffer;
                    continue block5;
                }
                default: {
                    currentBuffer.append(characters[i]);
                }
            }
        }
        parsedAddress = PathAddress.addpathAddressElement(parsedAddress, address, keyBuffer, valueBuffer);
        return parsedAddress;
    }

    private static PathAddress addpathAddressElement(PathAddress parsedAddress, String address, StringBuilder keyBuffer, StringBuilder valueBuffer) {
        if (keyBuffer.length() > 0) {
            if (valueBuffer.length() > 0) {
                return parsedAddress.append(PathElement.pathElement(keyBuffer.toString(), valueBuffer.toString()));
            }
            throw ControllerLogger.ROOT_LOGGER.illegalCLIStylePathAddress(address);
        }
        return parsedAddress;
    }

    private static OperationFailedRuntimeException duplicateElement(String name) {
        return ControllerLogger.ROOT_LOGGER.duplicateElement(name);
    }

    PathAddress(List<PathElement> pathAddressList) {
        Assert.assertNotNull(pathAddressList);
        this.pathAddressList = pathAddressList;
    }

    public PathElement getElement(int index) {
        List<PathElement> list = this.pathAddressList;
        return list.get(index);
    }

    public PathElement getLastElement() {
        List<PathElement> list = this.pathAddressList;
        return list.isEmpty() ? null : list.get(list.size() - 1);
    }

    public PathAddress subAddress(int start) {
        List<PathElement> list = this.pathAddressList;
        return new PathAddress(list.subList(start, list.size()));
    }

    public PathAddress subAddress(int start, int end) {
        return new PathAddress(this.pathAddressList.subList(start, end));
    }

    public PathAddress append(List<PathElement> additionalElements) {
        ArrayList<PathElement> newList = new ArrayList<PathElement>(this.pathAddressList.size() + additionalElements.size());
        newList.addAll(this.pathAddressList);
        newList.addAll(additionalElements);
        return PathAddress.pathAddress(newList);
    }

    public PathAddress append(PathElement ... additionalElements) {
        return this.append(Arrays.asList(additionalElements));
    }

    public PathAddress append(PathAddress address) {
        return this.append(address.pathAddressList);
    }

    public PathAddress append(String key, String value) {
        return this.append(PathElement.pathElement(key, value));
    }

    public PathAddress append(String key) {
        return this.append(PathElement.pathElement(key));
    }

    @Deprecated
    public ModelNode navigate(ModelNode model, boolean create) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (create && !i.hasNext()) {
                if (element.isMultiTarget()) {
                    throw new IllegalStateException();
                }
                model = model.require(element.getKey()).get(element.getValue());
                continue;
            }
            model = model.require(element.getKey()).require(element.getValue());
        }
        return model;
    }

    @Deprecated
    public ModelNode remove(ModelNode model) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (i.hasNext()) {
                model = model.require(element.getKey()).require(element.getValue());
                continue;
            }
            ModelNode parent = model.require(element.getKey());
            model = parent.remove(element.getValue()).clone();
        }
        return model;
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode().setEmptyList();
        for (PathElement element : this.pathAddressList) {
            String value = element.isMultiTarget() && !element.isWildcard() ? '[' + element.getValue() + ']' : element.getValue();
            node.add(element.getKey(), value);
        }
        return node;
    }

    public boolean isMultiTarget() {
        for (PathElement element : this.pathAddressList) {
            if (!element.isMultiTarget()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.pathAddressList.size();
    }

    @Override
    public ListIterator<PathElement> iterator() {
        return this.pathAddressList.listIterator();
    }

    public PathAddress getParent() {
        return this.subAddress(0, this.size() - 1);
    }

    public int hashCode() {
        return this.pathAddressList.hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PathAddress && this.equals((PathAddress)other);
    }

    public boolean equals(PathAddress other) {
        return this == other || other != null && this.pathAddressList.equals(other.pathAddressList);
    }

    public String toString() {
        return this.toModelNode().toString();
    }

    public String toCLIStyleString() {
        return this.toString('=');
    }

    public String toHttpStyleString() {
        return this.toString('/');
    }

    public String toPathStyleString() {
        return this.toString('/');
    }

    public boolean matches(PathAddress address) {
        if (address == null) {
            return false;
        }
        if (this.equals(address)) {
            return true;
        }
        if (this.size() != address.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            PathElement other;
            PathElement pe = this.getElement(i);
            if (pe.matches(other = address.getElement(i))) continue;
            if (pe.isMultiTarget() && !pe.isWildcard()) {
                boolean matched = false;
                for (String segment : pe.getSegments()) {
                    if (!segment.equals(other.getValue())) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private String toString(char keyValSeparator) {
        if (this.pathAddressList.isEmpty()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (PathElement pe : this.pathAddressList) {
            sb.append('/');
            sb.append(pe.getKey());
            sb.append(keyValSeparator);
            boolean quote = false;
            if (pe.getValue().contains("/") || pe.getValue().contains("=")) {
                quote = true;
            }
            if (quote) {
                sb.append("\"");
            }
            sb.append(pe.getValue());
            if (!quote) continue;
            sb.append("\"");
        }
        return sb.toString();
    }
}

