/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ConfigurationPublishHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "publish-configuration";
    private static final SimpleAttributeDefinition LOCATION = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("location", ModelType.STRING).setRequired(false)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("publish-configuration", ControllerResolver.getResolver("publish")).setParameters(LOCATION).setRuntimeOnly().withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SNAPSHOTS).build();
    private final ConfigurationPersister persister;

    public ConfigurationPublishHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authorizationResult = context.authorize(operation);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.get("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
        }
        String name = null;
        if (operation.hasDefined(LOCATION.getName())) {
            name = LOCATION.resolveModelAttribute(context, operation).asString();
        }
        try {
            context.getResult().set(this.persister.publish(name));
        }
        catch (ConfigurationPersistenceException e) {
            throw new OperationFailedException(e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

