/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;

public interface CapabilityReferenceRecorder {
    public void addCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    public void removeCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    public static class DefaultCapabilityReferenceRecorder
    implements CapabilityReferenceRecorder {
        private final String baseRequirementName;
        private final String baseDependentName;
        private final boolean dynamicDependent;

        public DefaultCapabilityReferenceRecorder(String baseRequirementName, String baseDependentName, boolean dynamicDependent) {
            this.baseRequirementName = baseRequirementName;
            this.baseDependentName = baseDependentName;
            this.dynamicDependent = dynamicDependent;
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove, String ... attributeValues) {
            String dependentName = this.dynamicDependent ? RuntimeCapability.buildDynamicCapabilityName(this.baseDependentName, this.getDynamicDependentName(context.getCurrentAddress())) : this.baseDependentName;
            for (String attributeValue : attributeValues) {
                String requirementName = RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
                if (remove) {
                    context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
                    continue;
                }
                context.deregisterCapabilityRequirement(requirementName, dependentName);
            }
        }

        protected String getDynamicDependentName(PathAddress currentAddress) {
            return currentAddress.getLastElement().getValue();
        }
    }
}

