/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.remote.ResponseAttachmentInputStreamSupport;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.action.GetAccessControlContextAction;

public abstract class AbstractModelControllerOperationHandlerFactoryService
implements Service<AbstractModelControllerOperationHandlerFactoryService>,
ManagementChannelInitialization {
    public static final ServiceName OPERATION_HANDLER_NAME_SUFFIX = ServiceName.of((String[])new String[]{"operation", "handler"});
    private static final int WORK_QUEUE_SIZE = 512;
    private static final int POOL_CORE_SIZE = 4;
    private static final int POOL_MAX_SIZE = 4;
    private final InjectedValue<ModelController> modelControllerValue = new InjectedValue();
    private final InjectedValue<ExecutorService> executor = new InjectedValue();
    private final InjectedValue<ScheduledExecutorService> scheduledExecutor = new InjectedValue();
    private ResponseAttachmentInputStreamSupport responseAttachmentSupport;
    private ExecutorService clientRequestExecutor;

    public InjectedValue<ModelController> getModelControllerInjector() {
        return this.modelControllerValue;
    }

    public InjectedValue<ExecutorService> getExecutorInjector() {
        return this.executor;
    }

    public InjectedValue<ScheduledExecutorService> getScheduledExecutorInjector() {
        return this.scheduledExecutor;
    }

    public synchronized void start(StartContext context) throws StartException {
        ControllerLogger.MGMT_OP_LOGGER.debugf("Starting operation handler service %s", context.getController().getName());
        this.responseAttachmentSupport = new ResponseAttachmentInputStreamSupport((ScheduledExecutorService)this.scheduledExecutor.getValue());
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(512);
        JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("management-handler-thread"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 4, 60L, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory);
        executor.allowCoreThreadTimeOut(true);
        this.clientRequestExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(final StopContext stopContext) {
        ExecutorService executorService = (ExecutorService)this.executor.getValue();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractModelControllerOperationHandlerFactoryService.this.responseAttachmentSupport.shutdown();
                    AbstractModelControllerOperationHandlerFactoryService.this.clientRequestExecutor.shutdown();
                }
                finally {
                    stopContext.complete();
                }
            }
        };
        try {
            executorService.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            stopContext.asynchronous();
        }
    }

    public synchronized AbstractModelControllerOperationHandlerFactoryService getValue() throws IllegalStateException {
        return this;
    }

    protected ModelController getController() {
        return (ModelController)this.modelControllerValue.getValue();
    }

    protected ExecutorService getExecutor() {
        return (ExecutorService)this.executor.getValue();
    }

    protected ResponseAttachmentInputStreamSupport getResponseAttachmentSupport() {
        return this.responseAttachmentSupport;
    }

    protected final ExecutorService getClientRequestExecutor() {
        return this.clientRequestExecutor;
    }
}

