/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.AttributeParser;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentSubsystemSchema;
import org.jboss.as.controller.ResourceMarshaller;
import org.jboss.as.controller.ResourceParser;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.Namespace;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class PersistentResourceXMLDescription
implements ResourceParser,
ResourceMarshaller {
    private final PathElement pathElement;
    private final String xmlElementName;
    private final String xmlWrapperElement;
    private final LinkedHashMap<String, LinkedHashMap<String, AttributeDefinition>> attributesByGroup;
    private final List<PersistentResourceXMLDescription> children;
    private final List<ResourceMarshaller> marshallers;
    private final Map<String, AttributeDefinition> attributeElements = new HashMap<String, AttributeDefinition>();
    private final boolean useValueAsElementName;
    private final boolean noAddOperation;
    private final AdditionalOperationsGenerator additionalOperationsGenerator;
    private final LinkedHashMap<String, ResourceParser> customChildParsers;
    private final String decoratorElement;
    private boolean flushRequired = true;
    private boolean childAlreadyRead = false;
    private final Map<String, AttributeParser> attributeParsers;
    private final Map<String, AttributeMarshaller> attributeMarshallers;
    private final boolean useElementsForGroups;
    private final String namespaceURI;
    private final Set<String> attributeGroups;
    private final String forcedName;
    private final boolean marshallDefaultValues;
    private final String nameAttributeName;

    private PersistentResourceXMLDescription(PersistentResourceXMLBuilder builder) {
        this.pathElement = builder.pathElement;
        this.xmlElementName = builder.xmlElementName;
        this.xmlWrapperElement = builder.xmlWrapperElement;
        this.useElementsForGroups = builder.useElementsForGroups;
        this.attributesByGroup = new LinkedHashMap();
        this.namespaceURI = builder.namespaceURI;
        this.attributeGroups = new HashSet<String>();
        if (this.useElementsForGroups) {
            this.attributesByGroup.put(null, new LinkedHashMap());
            for (AttributeDefinition attributeDefinition : builder.attributeList) {
                String adGroup = attributeDefinition.getAttributeGroup();
                LinkedHashMap<String, AttributeDefinition> forGroup = this.attributesByGroup.get(adGroup);
                if (forGroup == null) {
                    forGroup = new LinkedHashMap();
                    this.attributesByGroup.put(adGroup, forGroup);
                    this.attributeGroups.add(adGroup);
                }
                String adXmlName = attributeDefinition.getXmlName();
                forGroup.put(adXmlName, attributeDefinition);
                AttributeParser ap = builder.attributeParsers.getOrDefault(adXmlName, attributeDefinition.getParser());
                if (ap == null || !ap.isParseAsElement()) continue;
                this.attributeElements.put(ap.getXmlName(attributeDefinition), attributeDefinition);
            }
        } else {
            LinkedHashMap<String, AttributeDefinition> attrs = new LinkedHashMap<String, AttributeDefinition>();
            for (AttributeDefinition ad : builder.attributeList) {
                attrs.put(ad.getXmlName(), ad);
                AttributeParser ap = ad.getParser();
                if (ap == null || !ap.isParseAsElement()) continue;
                this.attributeElements.put(ap.getXmlName(ad), ad);
            }
            this.attributesByGroup.put(null, attrs);
        }
        this.children = new ArrayList<PersistentResourceXMLDescription>();
        this.marshallers = builder.marshallers;
        for (PersistentResourceXMLBuilder persistentResourceXMLBuilder : builder.childrenBuilders) {
            PersistentResourceXMLDescription child = persistentResourceXMLBuilder.build();
            this.children.add(child);
            this.marshallers.add(child);
        }
        this.children.addAll(builder.children);
        this.useValueAsElementName = builder.useValueAsElementName;
        this.noAddOperation = builder.noAddOperation;
        this.additionalOperationsGenerator = builder.additionalOperationsGenerator;
        this.attributeParsers = builder.attributeParsers;
        this.attributeMarshallers = builder.attributeMarshallers;
        this.forcedName = builder.forcedName;
        this.marshallDefaultValues = builder.marshallDefaultValues;
        this.nameAttributeName = builder.nameAttributeName;
        this.customChildParsers = builder.customChildParsers;
        this.decoratorElement = builder.decoratorElement;
    }

    public PathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public void parse(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (this.decoratorElement != null) {
            this.parseDecorator(reader, parentAddress, list);
            return;
        }
        if (this.xmlWrapperElement != null) {
            if (reader.getLocalName().equals(this.xmlWrapperElement)) {
                if (reader.hasNext() && reader.nextTag() == 2) {
                    return;
                }
            } else {
                throw ParseUtils.unexpectedElement(reader);
            }
            this.parseInternal(reader, parentAddress, list);
            while (reader.nextTag() != 2 && !reader.getLocalName().equals(this.xmlWrapperElement)) {
                this.parseInternal(reader, parentAddress, list);
            }
        } else {
            this.parseInternal(reader, parentAddress, list);
        }
    }

    private void parseDecorator(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        if (!reader.getLocalName().equals(this.decoratorElement)) {
            throw ParseUtils.unexpectedElement(reader, Collections.singleton(this.decoratorElement));
        }
        if (!reader.isEndElement()) {
            this.parseChildren(reader, parentAddress, list, new ModelNode());
        }
    }

    private void parseInternal(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = Util.createAddOperation();
        boolean wildcard = this.pathElement.isWildcard();
        String name = this.parseAttributeGroups(reader, op, wildcard);
        if (wildcard && name == null) {
            if (this.forcedName != null) {
                name = this.forcedName;
            } else {
                throw ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(new StringBuilder("name"), reader.getLocation());
            }
        }
        PathElement path = wildcard ? PathElement.pathElement(this.pathElement.getKey(), name) : this.pathElement;
        PathAddress address = parentAddress.append(path);
        if (!this.noAddOperation) {
            op.get("address").set(address.toModelNode());
            list.add(op);
        }
        if (this.additionalOperationsGenerator != null) {
            this.additionalOperationsGenerator.additionalOperations(address, op, list);
        }
        if (!reader.isEndElement()) {
            this.parseChildren(reader, address, list, op);
        }
    }

    private String parseAttributeGroups(XMLExtendedStreamReader reader, ModelNode op, boolean wildcard) throws XMLStreamException {
        String name = this.parseAttributes(reader, op, (Map<String, AttributeDefinition>)this.attributesByGroup.get(null), wildcard);
        if (!this.attributeGroups.isEmpty()) {
            while (reader.hasNext() && reader.nextTag() != 2) {
                String localName = reader.getLocalName();
                boolean element = this.attributeElements.containsKey(localName);
                if (element || this.attributeGroups.contains(localName)) {
                    if (element) {
                        AttributeDefinition ad = this.attributeElements.get(localName);
                        ad.getParser().parseElement(ad, reader, op);
                        String newLocalName = reader.getLocalName();
                        if (this.attributeGroups.contains(newLocalName)) {
                            this.parseGroup(reader, op, wildcard);
                            continue;
                        }
                        if (!reader.isEndElement() || this.attributeGroups.contains(newLocalName) || this.attributeElements.containsKey(newLocalName)) continue;
                        this.childAlreadyRead = true;
                        break;
                    }
                    this.parseGroup(reader, op, wildcard);
                    continue;
                }
                this.childAlreadyRead = true;
                return name;
            }
            this.flushRequired = false;
        }
        return name;
    }

    private void parseGroup(XMLExtendedStreamReader reader, ModelNode op, boolean wildcard) throws XMLStreamException {
        Map groupAttrs = this.attributesByGroup.get(reader.getLocalName());
        for (AttributeDefinition attrGroup : groupAttrs.values()) {
            if (!op.hasDefined(attrGroup.getName())) continue;
            throw ParseUtils.unexpectedElement(reader);
        }
        this.parseAttributes(reader, op, groupAttrs, wildcard);
        while (reader.hasNext() && reader.nextTag() != 2) {
            AttributeDefinition ad = (AttributeDefinition)groupAttrs.get(reader.getLocalName());
            if (ad != null) {
                ad.getParser().parseElement(ad, reader, op);
                continue;
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private String parseAttributes(XMLExtendedStreamReader reader, ModelNode op, Map<String, AttributeDefinition> attributes, boolean wildcard) throws XMLStreamException {
        String name = null;
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (wildcard && this.nameAttributeName.equals(attributeName)) {
                name = value;
                continue;
            }
            if (attributes.containsKey(attributeName)) {
                AttributeDefinition def = attributes.get(attributeName);
                AttributeParser parser = this.attributeParsers.getOrDefault(attributeName, def.getParser());
                assert (parser != null);
                parser.parseAndSetParameter(def, value, op, (XMLStreamReader)reader);
                continue;
            }
            LinkedHashSet<String> possible = new LinkedHashSet<String>(attributes.keySet());
            possible.add(this.nameAttributeName);
            throw ParseUtils.unexpectedAttribute(reader, i, possible);
        }
        if (this.attributeGroups.isEmpty() && !this.attributeElements.isEmpty() && reader.isStartElement()) {
            String originalStartElement = reader.getLocalName();
            if (reader.hasNext() && reader.nextTag() != 2) {
                do {
                    AttributeDefinition ad;
                    if ((ad = this.attributeElements.get(reader.getLocalName())) == null) {
                        this.childAlreadyRead = true;
                        return name;
                    }
                    AttributeParser parser = this.attributeParsers.getOrDefault(ad.getXmlName(), ad.getParser());
                    parser.parseElement(ad, reader, op);
                    this.childAlreadyRead = true;
                } while (!reader.getLocalName().equals(originalStartElement) && reader.hasNext() && reader.nextTag() != 2);
            }
        }
        return name;
    }

    private Map<String, PersistentResourceXMLDescription> getChildrenMap() {
        HashMap<String, PersistentResourceXMLDescription> res = new HashMap<String, PersistentResourceXMLDescription>();
        for (PersistentResourceXMLDescription child : this.children) {
            if (child.xmlWrapperElement != null) {
                res.put(child.xmlWrapperElement, child);
                continue;
            }
            res.put(child.xmlElementName, child);
        }
        return res;
    }

    private void parseChildren(XMLExtendedStreamReader reader, PathAddress parentAddress, List<ModelNode> list, ModelNode op) throws XMLStreamException {
        if (this.children.isEmpty()) {
            if (this.flushRequired && this.attributeGroups.isEmpty() && this.attributeElements.isEmpty()) {
                ParseUtils.requireNoContent(reader);
            }
            if (this.childAlreadyRead) {
                throw ParseUtils.unexpectedElement(reader);
            }
        } else {
            PersistentResourceXMLDescription decoratorChild;
            Map<String, PersistentResourceXMLDescription> children = this.getChildrenMap();
            if (this.childAlreadyRead && (decoratorChild = children.get(reader.getLocalName())) != null && decoratorChild.decoratorElement != null) {
                decoratorChild.parseDecorator(reader, parentAddress, list);
            }
            if (this.childAlreadyRead || reader.hasNext() && reader.nextTag() != 2) {
                do {
                    String localName;
                    ResourceParser child;
                    if ((child = (ResourceParser)children.get(localName = reader.getLocalName())) != null) {
                        child.parse(reader, parentAddress, list);
                        continue;
                    }
                    AttributeDefinition elementAd = this.attributeElements.get(localName);
                    if (elementAd != null) {
                        elementAd.getParser().parseElement(elementAd, reader, op);
                        continue;
                    }
                    child = this.customChildParsers.get(localName);
                    if (child != null) {
                        child.parse(reader, parentAddress, list);
                        continue;
                    }
                    throw ParseUtils.unexpectedElement(reader, children.keySet());
                } while (reader.hasNext() && reader.nextTag() != 2);
            }
        }
    }

    @Override
    public void persist(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.persist(writer, model, this.namespaceURI);
    }

    private void writeStartElement(XMLExtendedStreamWriter writer, String namespaceURI, String localName) throws XMLStreamException {
        if (namespaceURI != null) {
            writer.writeStartElement(namespaceURI, localName);
        } else {
            writer.writeStartElement(localName);
        }
    }

    private void startSubsystemElement(XMLExtendedStreamWriter writer, String namespaceURI, boolean empty) throws XMLStreamException {
        if (writer.getNamespaceContext().getPrefix(namespaceURI) == null) {
            writer.setDefaultNamespace(namespaceURI);
            if (empty) {
                writer.writeEmptyElement(Element.SUBSYSTEM.getLocalName());
            } else {
                writer.writeStartElement(Element.SUBSYSTEM.getLocalName());
            }
            writer.writeNamespace(null, namespaceURI);
        } else if (empty) {
            writer.writeEmptyElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        } else {
            writer.writeStartElement(namespaceURI, Element.SUBSYSTEM.getLocalName());
        }
    }

    private void persistDecorator(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        if (this.shouldWriteDecoratorAndElements(model)) {
            writer.writeStartElement(this.decoratorElement);
            this.persistChildren(writer, model);
            writer.writeEndElement();
        }
    }

    private boolean shouldWriteDecoratorAndElements(ModelNode model) {
        for (PersistentResourceXMLDescription child : this.children) {
            if (child.decoratorElement != null) {
                for (PersistentResourceXMLDescription decoratedChild : child.children) {
                    if (!this.definedInModel(model, decoratedChild)) continue;
                    return true;
                }
                continue;
            }
            if (!this.definedInModel(model, child)) continue;
            return true;
        }
        return !this.customChildParsers.isEmpty();
    }

    private boolean definedInModel(ModelNode model, PersistentResourceXMLDescription child) {
        PathElement pe = child.getPathElement();
        boolean wildcard = this.getPathElement().isWildcard();
        return wildcard ? model.hasDefined(pe.getKey()) : model.hasDefined(pe.getKeyValuePair());
    }

    public void persist(XMLExtendedStreamWriter writer, ModelNode model, String namespaceURI) throws XMLStreamException {
        boolean writeWrapper;
        if (this.decoratorElement != null) {
            this.persistDecorator(writer, model);
            return;
        }
        boolean wildcard = this.pathElement.isWildcard();
        model = wildcard ? model.get(this.pathElement.getKey()) : model.get(this.pathElement.getKeyValuePair());
        boolean isSubsystem = this.pathElement.getKey().equals("subsystem");
        if (!(isSubsystem || model.isDefined() || this.useValueAsElementName)) {
            return;
        }
        boolean bl = writeWrapper = this.xmlWrapperElement != null;
        if (writeWrapper) {
            this.writeStartElement(writer, namespaceURI, this.xmlWrapperElement);
        }
        if (wildcard) {
            for (String name : model.keys()) {
                ModelNode subModel = model.get(name);
                if (this.useValueAsElementName) {
                    this.writeStartElement(writer, namespaceURI, name);
                } else {
                    this.writeStartElement(writer, namespaceURI, this.xmlElementName);
                    writer.writeAttribute(this.nameAttributeName, name);
                }
                this.persistAttributes(writer, subModel);
                this.persistChildren(writer, subModel);
                writer.writeEndElement();
            }
        } else {
            boolean empty;
            boolean bl2 = empty = this.attributeGroups.isEmpty() && this.children.isEmpty();
            if (this.useValueAsElementName) {
                this.writeStartElement(writer, namespaceURI, this.getPathElement().getValue());
            } else if (isSubsystem) {
                this.startSubsystemElement(writer, namespaceURI, empty);
            } else {
                this.writeStartElement(writer, namespaceURI, this.xmlElementName);
            }
            this.persistAttributes(writer, model);
            this.persistChildren(writer, model);
            if (!isSubsystem || !empty) {
                writer.writeEndElement();
            }
        }
        if (writeWrapper) {
            writer.writeEndElement();
        }
    }

    private void persistAttributes(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        this.marshallAttributes(writer, model, this.attributesByGroup.get(null).values(), null);
        if (this.useElementsForGroups) {
            for (Map.Entry<String, LinkedHashMap<String, AttributeDefinition>> entry : this.attributesByGroup.entrySet()) {
                if (entry.getKey() == null) continue;
                this.marshallAttributes(writer, model, entry.getValue().values(), entry.getKey());
            }
        }
    }

    private void marshallAttributes(XMLExtendedStreamWriter writer, ModelNode model, Collection<AttributeDefinition> attributes, String group) throws XMLStreamException {
        boolean started = false;
        ArrayList<AttributeDefinition> sortedAds = new ArrayList<AttributeDefinition>(attributes.size());
        ArrayList<AttributeDefinition> elementAds = null;
        for (AttributeDefinition ad : attributes) {
            if (ad.getParser().isParseAsElement()) {
                if (elementAds == null) {
                    elementAds = new ArrayList<AttributeDefinition>();
                }
                elementAds.add(ad);
                continue;
            }
            sortedAds.add(ad);
        }
        if (elementAds != null) {
            sortedAds.addAll(elementAds);
        }
        for (AttributeDefinition ad : sortedAds) {
            AttributeMarshaller marshaller = this.attributeMarshallers.getOrDefault(ad.getXmlName(), ad.getMarshaller());
            if (!marshaller.isMarshallable(ad, model, this.marshallDefaultValues)) continue;
            if (!started && group != null) {
                if (elementAds != null) {
                    writer.writeStartElement(group);
                } else {
                    writer.writeEmptyElement(group);
                }
                started = true;
            }
            marshaller.marshall(ad, model, this.marshallDefaultValues, (XMLStreamWriter)writer);
        }
        if (elementAds != null && started) {
            writer.writeEndElement();
        }
    }

    public void persistChildren(XMLExtendedStreamWriter writer, ModelNode model) throws XMLStreamException {
        for (ResourceMarshaller child : this.marshallers) {
            child.persist(writer, model);
        }
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(PathElement pathElement) {
        return new PersistentResourceXMLBuilder(pathElement);
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(PathElement pathElement, String namespaceURI) {
        return new PersistentResourceXMLBuilder(pathElement, namespaceURI);
    }

    @Deprecated
    public static PersistentResourceXMLBuilder builder(PathElement path, Namespace namespace) {
        return new PersistentResourceXMLBuilder(path, namespace.getUri());
    }

    public static PersistentResourceXMLBuilder decorator(String elementName) {
        return new PersistentResourceXMLBuilder(PathElement.pathElement(elementName), null).setDecoratorGroup(elementName);
    }

    public static <S extends PersistentSubsystemSchema<S>> Factory factory(final PersistentSubsystemSchema<S> schema) {
        return new Factory(){

            @Override
            public Builder builder(ResourceRegistration registration) {
                if (!schema.enables(registration)) {
                    return new Builder(){

                        @Override
                        public Builder addChild(PersistentResourceXMLDescription description) {
                            return this;
                        }

                        @Override
                        public Builder addAttribute(AttributeDefinition attribute) {
                            return this;
                        }

                        @Override
                        public Builder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
                            return this;
                        }

                        @Override
                        public Builder addAttributes(AttributeDefinition ... attributes) {
                            return this;
                        }

                        @Override
                        public Builder addAttributes(Stream<? extends AttributeDefinition> attributes) {
                            return this;
                        }

                        @Override
                        public Builder addAttributes(Stream<? extends AttributeDefinition> attributes, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
                            return this;
                        }

                        @Override
                        public Builder setXmlWrapperElement(String xmlWrapperElement) {
                            return this;
                        }

                        @Override
                        public Builder setXmlElementName(String xmlElementName) {
                            return this;
                        }

                        @Override
                        public Builder setNoAddOperation(boolean noAddOperation) {
                            return this;
                        }

                        @Override
                        public Builder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
                            return this;
                        }

                        @Override
                        public Builder setUseElementsForGroups(boolean useElementsForGroups) {
                            return this;
                        }

                        @Override
                        public Builder setNameAttributeName(String nameAttributeName) {
                            return this;
                        }

                        @Override
                        public PersistentResourceXMLDescription build() {
                            return null;
                        }
                    };
                }
                PathElement path = registration.getPathElement();
                final PersistentResourceXMLBuilder builder = path.getKey().equals("subsystem") ? PersistentResourceXMLDescription.builder(path, schema.getNamespace()) : PersistentResourceXMLDescription.builder(path);
                return new Builder(){

                    @Override
                    public Builder addChild(PersistentResourceXMLDescription description) {
                        if (description != null) {
                            builder.addChild(description);
                        }
                        return this;
                    }

                    @Override
                    public Builder addAttribute(AttributeDefinition attribute) {
                        if (schema.enables(attribute)) {
                            builder.addAttribute(attribute);
                        }
                        return this;
                    }

                    @Override
                    public Builder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
                        if (schema.enables(attribute)) {
                            builder.addAttribute(attribute, attributeParser, attributeMarshaller);
                        }
                        return this;
                    }

                    @Override
                    public Builder addAttributes(AttributeDefinition ... attributes) {
                        for (AttributeDefinition attribute : attributes) {
                            if (!schema.enables(attribute)) continue;
                            builder.addAttribute(attribute);
                        }
                        return this;
                    }

                    @Override
                    public Builder addAttributes(Stream<? extends AttributeDefinition> attributes) {
                        builder.addAttributes(attributes.filter(schema::enables));
                        return this;
                    }

                    @Override
                    public Builder addAttributes(Stream<? extends AttributeDefinition> attributes, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
                        builder.addAttributes(attributes.filter(schema::enables), attributeParser, attributeMarshaller);
                        return this;
                    }

                    @Override
                    public Builder setXmlWrapperElement(String xmlWrapperElement) {
                        builder.setXmlElementName(xmlWrapperElement);
                        return this;
                    }

                    @Override
                    public Builder setXmlElementName(String xmlElementName) {
                        builder.setXmlElementName(xmlElementName);
                        return this;
                    }

                    @Override
                    public Builder setNoAddOperation(boolean noAddOperation) {
                        builder.setNoAddOperation(noAddOperation);
                        return this;
                    }

                    @Override
                    public Builder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
                        builder.setAdditionalOperationsGenerator(additionalOperationsGenerator);
                        return this;
                    }

                    @Override
                    public Builder setUseElementsForGroups(boolean useElementsForGroups) {
                        builder.setUseElementsForGroups(useElementsForGroups);
                        return this;
                    }

                    @Override
                    public Builder setNameAttributeName(String nameAttributeName) {
                        builder.setNameAttributeName(nameAttributeName);
                        return this;
                    }

                    @Override
                    public PersistentResourceXMLDescription build() {
                        return builder.build();
                    }
                };
            }
        };
    }

    @FunctionalInterface
    public static interface AdditionalOperationsGenerator {
        public void additionalOperations(PathAddress var1, ModelNode var2, List<ModelNode> var3);
    }

    public static final class PersistentResourceXMLBuilder
    implements Builder {
        private final PathElement pathElement;
        private final String namespaceURI;
        private String xmlElementName;
        private String xmlWrapperElement;
        private boolean useValueAsElementName;
        private boolean noAddOperation;
        private AdditionalOperationsGenerator additionalOperationsGenerator;
        private final LinkedList<AttributeDefinition> attributeList = new LinkedList();
        private final List<PersistentResourceXMLBuilder> childrenBuilders = new ArrayList<PersistentResourceXMLBuilder>();
        private final List<PersistentResourceXMLDescription> children = new ArrayList<PersistentResourceXMLDescription>();
        private final LinkedHashMap<String, AttributeParser> attributeParsers = new LinkedHashMap();
        private final LinkedHashMap<String, AttributeMarshaller> attributeMarshallers = new LinkedHashMap();
        private final LinkedHashMap<String, ResourceParser> customChildParsers = new LinkedHashMap();
        private final LinkedList<ResourceMarshaller> marshallers = new LinkedList();
        private boolean useElementsForGroups = true;
        private String forcedName;
        private boolean marshallDefaultValues = true;
        private String nameAttributeName = "name";
        private String decoratorElement = null;

        private PersistentResourceXMLBuilder(PathElement pathElement) {
            this.pathElement = pathElement;
            this.namespaceURI = null;
            this.xmlElementName = pathElement.isWildcard() ? pathElement.getKey() : pathElement.getValue();
        }

        private PersistentResourceXMLBuilder(PathElement pathElement, String namespaceURI) {
            this.pathElement = pathElement;
            this.namespaceURI = namespaceURI;
            this.xmlElementName = pathElement.isWildcard() ? pathElement.getKey() : pathElement.getValue();
        }

        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLBuilder builder) {
            this.childrenBuilders.add(builder);
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addChild(PersistentResourceXMLDescription description) {
            if (description != null) {
                this.children.add(description);
                this.marshallers.add(description);
            }
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute) {
            this.attributeList.add(attribute);
            return this;
        }

        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser) {
            this.attributeList.add(attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addAttribute(AttributeDefinition attribute, AttributeParser attributeParser, AttributeMarshaller attributeMarshaller) {
            this.attributeList.add(attribute);
            this.attributeParsers.put(attribute.getXmlName(), attributeParser);
            this.attributeMarshallers.put(attribute.getXmlName(), attributeMarshaller);
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addAttributes(AttributeDefinition ... attributes) {
            Collections.addAll(this.attributeList, attributes);
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addAttributes(Stream<? extends AttributeDefinition> attributes) {
            attributes.forEach(this::addAttribute);
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder addAttributes(Stream<? extends AttributeDefinition> attributes, AttributeParser parser, AttributeMarshaller attributeMarshaller) {
            attributes.forEach(attribute -> this.addAttribute((AttributeDefinition)attribute, parser, attributeMarshaller));
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setXmlWrapperElement(String xmlWrapperElement) {
            this.xmlWrapperElement = xmlWrapperElement;
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setXmlElementName(String xmlElementName) {
            this.xmlElementName = xmlElementName;
            return this;
        }

        @Deprecated(forRemoval=true)
        public PersistentResourceXMLBuilder setUseValueAsElementName(boolean useValueAsElementName) {
            this.useValueAsElementName = useValueAsElementName;
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setNoAddOperation(boolean noAddOperation) {
            this.noAddOperation = noAddOperation;
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setAdditionalOperationsGenerator(AdditionalOperationsGenerator additionalOperationsGenerator) {
            this.additionalOperationsGenerator = additionalOperationsGenerator;
            return this;
        }

        @Deprecated(forRemoval=true)
        public PersistentResourceXMLBuilder setForcedName(String forcedName) {
            this.forcedName = forcedName;
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setUseElementsForGroups(boolean useElementsForGroups) {
            this.useElementsForGroups = useElementsForGroups;
            return this;
        }

        public PersistentResourceXMLBuilder setMarshallDefaultValues(boolean marshallDefault) {
            this.marshallDefaultValues = marshallDefault;
            return this;
        }

        @Override
        public PersistentResourceXMLBuilder setNameAttributeName(String nameAttributeName) {
            this.nameAttributeName = nameAttributeName;
            return this;
        }

        private PersistentResourceXMLBuilder setDecoratorGroup(String elementName) {
            this.decoratorElement = elementName;
            return this;
        }

        @Override
        public PersistentResourceXMLDescription build() {
            return new PersistentResourceXMLDescription(this);
        }
    }

    public static interface Builder {
        public Builder addChild(PersistentResourceXMLDescription var1);

        public Builder addAttribute(AttributeDefinition var1);

        public Builder addAttribute(AttributeDefinition var1, AttributeParser var2, AttributeMarshaller var3);

        public Builder addAttributes(AttributeDefinition ... var1);

        public Builder addAttributes(Stream<? extends AttributeDefinition> var1);

        public Builder addAttributes(Stream<? extends AttributeDefinition> var1, AttributeParser var2, AttributeMarshaller var3);

        public Builder setXmlWrapperElement(String var1);

        public Builder setXmlElementName(String var1);

        public Builder setNoAddOperation(boolean var1);

        public Builder setAdditionalOperationsGenerator(AdditionalOperationsGenerator var1);

        public Builder setUseElementsForGroups(boolean var1);

        public Builder setNameAttributeName(String var1);

        public PersistentResourceXMLDescription build();
    }

    public static interface Factory {
        default public Builder builder(PathElement path) {
            return this.builder(ResourceRegistration.of(path));
        }

        public Builder builder(ResourceRegistration var1);
    }
}

