/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public interface CapabilityReferenceRecorder {
    @Deprecated
    public void addCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    default public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.addCapabilityRequirements(context, attributeName, attributeValues);
    }

    @Deprecated
    public void removeCapabilityRequirements(OperationContext var1, String var2, String ... var3);

    default public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
        this.removeCapabilityRequirements(context, attributeName, attributeValues);
    }

    @Deprecated
    public String getBaseDependentName();

    public String getBaseRequirementName();

    @Deprecated
    public boolean isDynamicDependent();

    public static class ResourceNameCompositeDependencyRecorder
    extends CompositeAttributeDependencyRecorder {
        public ResourceNameCompositeDependencyRecorder(String baseRequirementName) {
            super(baseRequirementName, new AttributeDefinition[0]);
        }

        @Override
        protected String getRequirementName(OperationContext context, Resource resource, String attributeValue) {
            return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, context.getCurrentAddressValue(), attributeValue);
        }
    }

    public static class CompositeAttributeDependencyRecorder
    extends ContextDependencyRecorder {
        private AttributeDefinition[] attributes;
        private RuntimeCapability capability;

        public CompositeAttributeDependencyRecorder(String baseRequirementName, AttributeDefinition ... attributes) {
            super(baseRequirementName);
            this.attributes = attributes;
            this.capability = null;
        }

        public CompositeAttributeDependencyRecorder(RuntimeCapability capability, String baseRequirementName, AttributeDefinition ... attributes) {
            super(baseRequirementName);
            this.attributes = attributes;
            this.capability = capability;
        }

        @Override
        protected RuntimeCapability getDependentCapability(OperationContext context) {
            if (this.capability != null) {
                return this.capability;
            }
            return super.getDependentCapability(context);
        }

        @Override
        protected String getRequirementName(OperationContext context, Resource resource, String attributeValue) {
            ModelNode model = resource.getModel();
            String[] dynamicParts = new String[this.attributes.length + 1];
            try {
                for (int i = 0; i < this.attributes.length; ++i) {
                    AttributeDefinition ad = this.attributes[i];
                    dynamicParts[i] = ad.resolveModelAttribute(context, model).asString();
                }
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
            dynamicParts[this.attributes.length] = attributeValue;
            return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, dynamicParts);
        }
    }

    public static class ContextDependencyRecorder
    implements CapabilityReferenceRecorder {
        final String baseRequirementName;

        public ContextDependencyRecorder(String baseRequirementName) {
            this.baseRequirementName = baseRequirementName;
        }

        @Override
        public void addCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, resource, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, resource, attributeName, true, attributeValues);
        }

        protected void processCapabilityRequirement(OperationContext context, Resource resource, String attributeName, boolean remove, String ... attributeValues) {
            RuntimeCapability cap = this.getDependentCapability(context);
            String dependentName = this.getDependentName(cap, context);
            for (String attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                String requirementName = this.getRequirementName(context, resource, attributeValue);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        protected RuntimeCapability getDependentCapability(OperationContext context) {
            ImmutableManagementResourceRegistration mrr = context.getResourceRegistration();
            Set<RuntimeCapability> capabilities = mrr.getCapabilities();
            assert (capabilities != null && capabilities.size() == 1);
            return capabilities.iterator().next();
        }

        protected String getDependentName(RuntimeCapability cap, OperationContext context) {
            if (cap.isDynamicallyNamed()) {
                return cap.fromBaseCapability(context.getCurrentAddress()).getName();
            }
            return cap.getName();
        }

        protected String getRequirementName(OperationContext context, Resource resource, String attributeValue) {
            return RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
        }

        @Override
        public String getBaseDependentName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }

        @Override
        public boolean isDynamicDependent() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DefaultCapabilityReferenceRecorder
    implements CapabilityReferenceRecorder {
        private final String baseRequirementName;
        private final String baseDependentName;
        private final boolean dynamicDependent;

        public DefaultCapabilityReferenceRecorder(String baseRequirementName, String baseDependentName, boolean dynamicDependent) {
            this.baseRequirementName = baseRequirementName;
            this.baseDependentName = baseDependentName;
            this.dynamicDependent = dynamicDependent;
        }

        @Override
        @Deprecated
        public void addCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        @Override
        @Deprecated
        public void removeCapabilityRequirements(OperationContext context, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        @Override
        public final void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, false, attributeValues);
        }

        @Override
        public final void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... attributeValues) {
            this.processCapabilityRequirement(context, attributeName, true, attributeValues);
        }

        private void processCapabilityRequirement(OperationContext context, String attributeName, boolean remove, String ... attributeValues) {
            String dependentName = this.dynamicDependent ? RuntimeCapability.buildDynamicCapabilityName(this.baseDependentName, this.getDynamicDependentName(context.getCurrentAddress())) : this.baseDependentName;
            for (String attributeValue : attributeValues) {
                if (attributeValue == null) continue;
                String requirementName = RuntimeCapability.buildDynamicCapabilityName(this.baseRequirementName, attributeValue);
                if (remove) {
                    context.deregisterCapabilityRequirement(requirementName, dependentName);
                    continue;
                }
                context.registerAdditionalCapabilityRequirement(requirementName, dependentName, attributeName);
            }
        }

        protected String getDynamicDependentName(PathAddress currentAddress) {
            return currentAddress.getLastElement().getValue();
        }

        @Override
        public String getBaseDependentName() {
            return this.baseDependentName;
        }

        @Override
        public String getBaseRequirementName() {
            return this.baseRequirementName;
        }

        @Override
        public boolean isDynamicDependent() {
            return this.dynamicDependent;
        }
    }
}

