/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.services.path.PathAddHandler;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;

public class PathRemoveHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "remove";
    private final PathManagerService pathManager;

    PathRemoveHandler(PathManagerService pathManager) {
        this.pathManager = pathManager;
    }

    @Deprecated
    protected PathRemoveHandler(PathManagerService pathManager, boolean services) {
        this(services ? null : pathManager);
        assert (!services || pathManager != null);
    }

    static PathRemoveHandler createNamedInstance() {
        return new PathRemoveHandler(null);
    }

    static PathRemoveHandler createSpecifiedInstance(PathManagerService pathManager) {
        assert (pathManager != null);
        return new PathRemoveHandler(pathManager);
    }

    static PathRemoveHandler createSpecifiedNoServicesInstance() {
        return new PathRemoveHandler(null);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final String name = context.getCurrentAddressValue();
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (model.get(PathResourceDefinition.READ_ONLY.getName()).asBoolean(false)) {
            throw ControllerLogger.ROOT_LOGGER.cannotRemoveReadOnlyPath(name);
        }
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (this.pathManager != null) {
            String relativeTo;
            String path;
            final PathManagerService.PathEventContextImpl pathEventContext = this.pathManager.checkRestartRequired(context, name, PathManager.Event.REMOVED);
            if (pathEventContext.isInstallServices()) {
                this.pathManager.removePathEntry(name, true);
                path = PathAddHandler.getPathValue(context, PathResourceDefinition.PATH_SPECIFIED, model);
                relativeTo = PathAddHandler.getPathValue(context, PathResourceDefinition.RELATIVE_TO, model);
            } else {
                relativeTo = null;
                path = null;
            }
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (pathEventContext.isInstallServices()) {
                        PathRemoveHandler.this.pathManager.removePathService(context, name);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            try {
                                if (pathEventContext.isInstallServices()) {
                                    ServiceTarget target = context.getServiceTarget();
                                    if (relativeTo == null) {
                                        PathRemoveHandler.this.pathManager.addAbsolutePathService(target, name, path);
                                    } else {
                                        PathRemoveHandler.this.pathManager.addRelativePathService(target, name, path, false, relativeTo);
                                    }
                                } else {
                                    context.revertRestartRequired();
                                }
                            }
                            catch (Exception e) {
                                ControllerLogger.MGMT_OP_LOGGER.errorRevertingOperation(e, this.getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress(operation.get("address")));
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep(new OperationContext.RollbackHandler(){

                @Override
                public void handleRollback(OperationContext context, ModelNode operation) {
                    if (pathEventContext.isInstallServices()) {
                        PathRemoveHandler.this.pathManager.addPathEntry(name, path, relativeTo, false);
                    }
                }
            });
        }
    }
}

