/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

public class DeferredExtensionContext {
    private final ModuleLoader moduleLoader;
    private final ExtensionRegistry extensionRegistry;
    private final ExecutorService bootExecutor;
    private final List<ExtensionData> extensions = new ArrayList<ExtensionData>();
    private boolean loaded;

    public DeferredExtensionContext(ModuleLoader moduleLoader, ExtensionRegistry extensionRegistry, ExecutorService bootExecutor) {
        this.moduleLoader = moduleLoader;
        this.extensionRegistry = extensionRegistry;
        this.bootExecutor = bootExecutor;
    }

    public void load() throws XMLStreamException {
        if (!this.loaded) {
            XMLStreamException xse;
            this.loaded = true;
            int maxInitializationTasks = this.extensionRegistry.getMaxParallelBootExtensionTasks();
            GroupLoadTask[] loadTasks = this.bootExecutor != null && maxInitializationTasks > 1 ? new GroupLoadTask[maxInitializationTasks] : null;
            int taskIdx = -1;
            for (ExtensionData extension : this.extensions) {
                String moduleName = extension.moduleName;
                XMLMapper xmlMapper = extension.xmlMapper;
                if (loadTasks != null) {
                    taskIdx = taskIdx == maxInitializationTasks - 1 ? 0 : ++taskIdx;
                    LoadTask loadTask = new LoadTask(moduleName, xmlMapper);
                    if (loadTasks[taskIdx] == null) {
                        loadTasks[taskIdx] = new GroupLoadTask(loadTask);
                        continue;
                    }
                    loadTasks[taskIdx].loadTasks.add(loadTask);
                    continue;
                }
                xse = this.loadModule(moduleName, xmlMapper);
                if (xse == null) continue;
                throw xse;
            }
            if (loadTasks != null) {
                for (GroupLoadTask loadTask : loadTasks) {
                    if (loadTask == null) continue;
                    loadTask.execute(this.bootExecutor);
                }
                for (GroupLoadTask loadTask : loadTasks) {
                    if (loadTask == null) continue;
                    try {
                        xse = (XMLStreamException)loadTask.future.get();
                        if (xse == null) continue;
                        throw xse;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerLogger.ROOT_LOGGER.moduleLoadingInterrupted(loadTask.currentModule);
                    }
                    catch (ExecutionException e) {
                        throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e, loadTask.currentModule);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLStreamException loadModule(String moduleName, XMLMapper xmlMapper) throws XMLStreamException {
        try {
            Module module = this.moduleLoader.loadModule(ModuleIdentifier.fromString((String)moduleName));
            boolean initialized = false;
            for (Extension extension : module.loadService(Extension.class)) {
                ClassLoader oldTccl = WildFlySecurityManager.setCurrentContextClassLoaderPrivileged(extension.getClass());
                try {
                    this.extensionRegistry.initializeParsers(extension, moduleName, xmlMapper);
                }
                finally {
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                }
                if (initialized) continue;
                initialized = true;
            }
            if (!initialized) {
                throw ControllerLogger.ROOT_LOGGER.notFound("META-INF/services/", Extension.class.getName(), module.getName());
            }
            return null;
        }
        catch (ModuleLoadException e) {
            throw ControllerLogger.ROOT_LOGGER.failedToLoadModule(e);
        }
    }

    public void addExtension(String moduleName, XMLMapper xmlMapper) {
        this.extensions.add(new ExtensionData(moduleName, xmlMapper));
    }

    private static class GroupLoadTask
    implements Callable<XMLStreamException> {
        private final List<LoadTask> loadTasks = new ArrayList<LoadTask>();
        private volatile String currentModule;
        private volatile Future<XMLStreamException> future;

        private GroupLoadTask(LoadTask first) {
            this.currentModule = first.moduleName;
            this.loadTasks.add(first);
        }

        @Override
        public XMLStreamException call() throws Exception {
            for (LoadTask task : this.loadTasks) {
                this.currentModule = task.moduleName;
                XMLStreamException ex = task.call();
                if (ex == null) continue;
                return ex;
            }
            return null;
        }

        private void execute(ExecutorService executorService) {
            this.future = executorService.submit(this);
        }
    }

    private class LoadTask
    implements Callable<XMLStreamException> {
        private final String moduleName;
        private final XMLMapper xmlMapper;

        private LoadTask(String moduleName, XMLMapper xmlMapper) {
            this.moduleName = moduleName;
            this.xmlMapper = xmlMapper;
        }

        @Override
        public XMLStreamException call() throws Exception {
            return DeferredExtensionContext.this.loadModule(this.moduleName, this.xmlMapper);
        }
    }

    private class ExtensionData {
        final String moduleName;
        final XMLMapper xmlMapper;

        private ExtensionData(String moduleName, XMLMapper xmlMapper) {
            this.moduleName = moduleName;
            this.xmlMapper = xmlMapper;
        }
    }
}

