/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.protocol.logging.ProtocolLogger;
import org.jboss.as.protocol.mgmt.AbstractMessageHandler;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.Cancellable;

class ManagementRequestContextImpl<T, A>
implements ManagementRequestContext<A> {
    private final ActiveOperation<T, A> support;
    private final Channel channel;
    private final ManagementProtocolHeader header;
    private final Executor executor;

    ManagementRequestContextImpl(ActiveOperation<T, A> support, Channel channel, ManagementProtocolHeader header, Executor executor) {
        this.support = support;
        this.channel = channel;
        this.header = header;
        this.executor = executor;
    }

    @Override
    public Integer getOperationId() {
        return this.support.getOperationId();
    }

    @Override
    public A getAttachment() {
        return this.support.getAttachment();
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ManagementProtocolHeader getRequestHeader() {
        return this.header;
    }

    Runnable createAsyncTaskRunner(final ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
        final ManagementRequestContextImpl context = this;
        AsyncTaskRunner runner = new AsyncTaskRunner(cancellable){

            @Override
            protected void doExecute() {
                try {
                    task.execute(context);
                }
                catch (Throwable t) {
                    if (ManagementRequestContextImpl.this.support.getResultHandler().failed(t)) {
                        ManagementProtocolHeader requestHeader;
                        requestHeader = task instanceof ManagementRequestContext.MultipleResponseAsyncTask ? ((requestHeader = ((ManagementRequestContext.MultipleResponseAsyncTask)task).getCurrentRequestHeader()) == null ? ManagementRequestContextImpl.this.header : requestHeader) : ManagementRequestContextImpl.this.header;
                        AbstractMessageHandler.safeWriteErrorResponse(ManagementRequestContextImpl.this.channel, requestHeader, t);
                    }
                    ProtocolLogger.ROOT_LOGGER.debugf(t, " failed to process async request for %s on channel %s", task, ManagementRequestContextImpl.this.channel);
                }
            }
        };
        if (cancellable) {
            this.support.addCancellable(runner);
        }
        return runner;
    }

    @Override
    public boolean executeAsync(ManagementRequestContext.AsyncTask<A> task) {
        return this.executeAsync(task, true, this.executor);
    }

    @Override
    public boolean executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable) {
        return this.executeAsync(task, cancellable, this.executor);
    }

    @Override
    public boolean executeAsync(ManagementRequestContext.AsyncTask<A> task, Executor executor) {
        return this.executeAsync(task, true, executor);
    }

    @Override
    public boolean executeAsync(ManagementRequestContext.AsyncTask<A> task, boolean cancellable, Executor executor) {
        try {
            executor.execute(this.createAsyncTaskRunner(task, cancellable));
            return true;
        }
        catch (RejectedExecutionException e) {
            if (this.support.getResultHandler().failed(e)) {
                AbstractMessageHandler.safeWriteErrorResponse(this.channel, this.header, e);
            }
            return false;
        }
    }

    @Override
    public FlushableDataOutput writeMessage(ManagementProtocolHeader header) throws IOException {
        MessageOutputStream os = this.channel.writeMessage();
        return AbstractMessageHandler.writeHeader(header, (OutputStream)os);
    }

    private static abstract class AsyncTaskRunner
    implements Runnable,
    Cancellable {
        private final boolean cancellable;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private volatile Thread thread;

        private AsyncTaskRunner(boolean cancellable) {
            this.cancellable = cancellable;
        }

        public Cancellable cancel() {
            Thread thread;
            if (this.cancellable && this.cancelled.compareAndSet(false, true) && (thread = this.thread) != null) {
                thread.interrupt();
                ProtocolLogger.ROOT_LOGGER.cancelledAsyncTask(this.getClass().getSimpleName(), thread);
            }
            return this;
        }

        protected abstract void doExecute();

        @Override
        public void run() {
            if (this.cancellable && this.cancelled.get()) {
                Thread.currentThread().interrupt();
                ProtocolLogger.ROOT_LOGGER.cancelledAsyncTaskBeforeRun(this.getClass().getSimpleName());
            }
            this.thread = Thread.currentThread();
            try {
                this.doExecute();
            }
            finally {
                this.thread = null;
            }
        }

        final boolean isCancelled() {
            return this.cancelled.get();
        }
    }
}

