/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.as.protocol.mgmt.support.ManagementChannelInitialization;
import org.jboss.msc.service.StartException;

public class ManagementRequestTracker {
    private volatile boolean shutdown;
    private final List<ManagementChannelInitialization.ManagementChannelShutdownHandle> trackers = Collections.synchronizedList(new ArrayList());

    ManagementRequestTracker() {
    }

    synchronized void reset() throws StartException {
        this.shutdown = false;
    }

    synchronized void stop() {
        this.shutdown = true;
        ArrayList<ManagementChannelInitialization.ManagementChannelShutdownHandle> trackers = new ArrayList<ManagementChannelInitialization.ManagementChannelShutdownHandle>(this.trackers);
        for (ManagementChannelInitialization.ManagementChannelShutdownHandle tracker : trackers) {
            tracker.shutdownNow();
        }
        this.trackers.clear();
        this.notifyAll();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public synchronized void prepareShutdown() {
        this.shutdown = true;
        ArrayList<ManagementChannelInitialization.ManagementChannelShutdownHandle> trackers = new ArrayList<ManagementChannelInitialization.ManagementChannelShutdownHandle>(this.trackers);
        for (ManagementChannelInitialization.ManagementChannelShutdownHandle tracker : trackers) {
            tracker.shutdown();
        }
    }

    public synchronized void registerTracker(ManagementChannelInitialization.ManagementChannelShutdownHandle tracker) {
        if (!this.shutdown) {
            this.trackers.add(tracker);
        } else {
            tracker.shutdown();
        }
    }

    public synchronized void unregisterTracker(ManagementChannelInitialization.ManagementChannelShutdownHandle tracker) {
        this.trackers.remove(tracker);
        this.notifyAll();
    }

    public synchronized boolean awaitShutdown(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (!this.shutdown || !this.trackers.isEmpty()) {
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) {
                return false;
            }
            this.wait(remaining);
        }
        return true;
    }
}

