/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.SocketBindingAddHandler;
import org.jboss.as.controller.operations.validation.MaskedAddressValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingResourceDefinition;
import org.jboss.as.server.services.net.SocketBindingService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class BindingAddHandler
extends SocketBindingAddHandler {
    public static final BindingAddHandler INSTANCE = new BindingAddHandler();
    private static final InetAddress ANY_IPV6;

    private BindingAddHandler() {
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        this.populateModel(operation, model);
        SocketBindingResourceDefinition.validateInterfaceReference(context, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        try {
            newControllers.add(BindingAddHandler.installBindingService(context, model, name, verificationHandler));
        }
        catch (UnknownHostException e) {
            throw new OperationFailedException(new ModelNode().set(e.getLocalizedMessage()));
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    public static ServiceController<SocketBinding> installBindingService(OperationContext context, ModelNode config, String name, ServiceVerificationHandler verificationHandler) throws UnknownHostException, OperationFailedException {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode intfNode = AbstractSocketBindingResourceDefinition.INTERFACE.resolveModelAttribute(context, config);
        String intf = intfNode.isDefined() ? intfNode.asString() : null;
        int port = AbstractSocketBindingResourceDefinition.PORT.resolveModelAttribute(context, config).asInt();
        boolean fixedPort = AbstractSocketBindingResourceDefinition.FIXED_PORT.resolveModelAttribute(context, config).asBoolean();
        ModelNode mcastNode = AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.resolveModelAttribute(context, config);
        String mcastAddr = mcastNode.isDefined() ? mcastNode.asString() : null;
        int mcastPort = AbstractSocketBindingResourceDefinition.MULTICAST_PORT.resolveModelAttribute(context, config).asInt(0);
        InetAddress mcastInet = mcastAddr == null ? null : InetAddress.getByName(mcastAddr);
        ModelNode mappingsNode = config.get("client-mappings");
        List<ClientMapping> clientMappings = mappingsNode.isDefined() ? BindingAddHandler.parseClientMappings(mappingsNode) : null;
        SocketBindingService service = new SocketBindingService(name, port, fixedPort, mcastInet, mcastPort, clientMappings);
        ServiceBuilder builder = serviceTarget.addService(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{name}), (Service)service);
        if (intf != null) {
            builder.addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{intf}), NetworkInterfaceBinding.class, service.getInterfaceBinding());
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.addDependency(SocketBindingManager.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindings()).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public static List<ClientMapping> parseClientMappings(ModelNode mappings) throws OperationFailedException {
        ArrayList<ClientMapping> clientMappings = new ArrayList<ClientMapping>();
        for (ModelNode mappingNode : mappings.asList()) {
            int mask;
            InetAddress sourceAddress;
            ModelNode sourceNode = mappingNode.get("source-network");
            if (sourceNode.isDefined()) {
                MaskedAddressValidator.ParsedResult parsedResult = MaskedAddressValidator.parseMasked((ModelNode)sourceNode);
                sourceAddress = parsedResult.address;
                mask = parsedResult.mask;
            } else {
                sourceAddress = ANY_IPV6;
                mask = 0;
            }
            ModelNode destinationNode = mappingNode.get("destination-address");
            if (!destinationNode.isDefined()) {
                throw ControllerLogger.ROOT_LOGGER.nullNotAllowed("destination-address");
            }
            String destination = destinationNode.asString();
            ModelNode portNode = mappingNode.get("destination-port");
            int port = portNode.isDefined() ? portNode.asInt() : -1;
            clientMappings.add(new ClientMapping(sourceAddress, mask, destination, port));
        }
        return clientMappings;
    }

    static {
        try {
            ANY_IPV6 = InetAddress.getByAddress(new byte[16]);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Not possible");
        }
    }
}

