/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.operations.HttpManagementAddHandler;
import org.jboss.as.server.operations.HttpManagementRemoveHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HttpManagementResourceDefinition
extends SimpleResourceDefinition {
    private static final PathElement RESOURCE_PATH = PathElement.pathElement((String)"management-interface", (String)"http-interface");
    private static final OperationStepHandler VALIDATING_HANDLER = new HttpManagementValidatingHandler();
    public static final SimpleAttributeDefinition SECURITY_REALM = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SECURITY_REALM_REF))).build();
    public static final SimpleAttributeDefinition INTERFACE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("interface", ModelType.STRING, false).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, true))).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"})).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition HTTP_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("port", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"})).setRequires(new String[]{"interface"})).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition HTTPS_PORT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-port", ModelType.INT, true).setAllowExpression(true)).setValidator((ParameterValidator)new IntRangeValidator(0, 65535, true, true))).setAlternatives(new String[]{"socket-binding", "secure-socket-binding"})).setRequires(new String[]{"interface"})).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).setDeprecated(ModelVersion.create((int)1, (int)4))).build();
    public static final SimpleAttributeDefinition SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("socket-binding", ModelType.STRING, true).setXmlName(Attribute.HTTP.getLocalName())).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAlternatives(new String[]{"interface"})).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).build();
    public static final SimpleAttributeDefinition SECURE_SOCKET_BINDING = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("secure-socket-binding", ModelType.STRING, true).setXmlName(Attribute.HTTPS.getLocalName())).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setAlternatives(new String[]{"interface"})).addAccessConstraint((AccessConstraintDefinition)new SensitiveTargetAccessConstraintDefinition(SensitivityClassification.SOCKET_CONFIG))).build();
    public static final SimpleAttributeDefinition CONSOLE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("console-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.CONSOLE_ENABLED.getLocalName())).setDefaultValue(new ModelNode(true))).build();
    public static final SimpleAttributeDefinition HTTP_UPGRADE_ENABLED = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("http-upgrade-enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.HTTP_UPGRADE_ENABLED.getLocalName())).setDefaultValue(new ModelNode(false))).build();
    public static final SimpleAttributeDefinition SERVER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server-name", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final SimpleAttributeDefinition SASL_PROTOCOL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sasl-protocol", ModelType.STRING, true).setAllowExpression(true)).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false))).setDefaultValue(new ModelNode("remote"))).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    public static final AttributeDefinition[] ATTRIBUTE_DEFINITIONS = new AttributeDefinition[]{INTERFACE, HTTP_PORT, HTTPS_PORT, SECURITY_REALM, SOCKET_BINDING, SECURE_SOCKET_BINDING, CONSOLE_ENABLED, HTTP_UPGRADE_ENABLED, SASL_PROTOCOL, SERVER_NAME};
    public static final HttpManagementResourceDefinition INSTANCE = new HttpManagementResourceDefinition();
    private final List<AccessConstraintDefinition> accessConstraints = SensitiveTargetAccessConstraintDefinition.MANAGEMENT_INTERFACES.wrapAsList();

    private HttpManagementResourceDefinition() {
        super(RESOURCE_PATH, ServerDescriptions.getResourceDescriptionResolver("core.management.http-interface"), (OperationStepHandler)HttpManagementAddHandler.INSTANCE, (OperationStepHandler)HttpManagementRemoveHandler.INSTANCE, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_NONE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        WriteAttributeHandler writeAttributeHandler = new WriteAttributeHandler(ATTRIBUTE_DEFINITIONS);
        for (AttributeDefinition attr : ATTRIBUTE_DEFINITIONS) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)writeAttributeHandler);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public static void addValidatingHandler(OperationContext operationContext, ModelNode fromOperation) {
        ModelNode operation = Util.createOperation((String)"validate-http-interface", (PathAddress)PathAddress.pathAddress((ModelNode)fromOperation.require("address")));
        operationContext.addStep(operation, VALIDATING_HANDLER, OperationContext.Stage.MODEL);
    }

    private static class HttpManagementValidatingHandler
    implements OperationStepHandler {
        private HttpManagementValidatingHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
            if (model.hasDefined(INTERFACE.getName()) && (model.hasDefined(SOCKET_BINDING.getName()) || model.hasDefined(SECURE_SOCKET_BINDING.getName()))) {
                throw ServerLogger.ROOT_LOGGER.illegalCombinationOfHttpManagementInterfaceConfigurations(INTERFACE.getName(), SOCKET_BINDING.getName(), SECURE_SOCKET_BINDING.getName());
            }
            if (!model.hasDefined(SECURITY_REALM.getName()) && (model.hasDefined(SECURE_SOCKET_BINDING.getName()) || model.hasDefined(HTTPS_PORT.getName()))) {
                throw ServerLogger.ROOT_LOGGER.noSecurityRealmForSsl();
            }
            context.stepCompleted();
        }
    }

    private static class WriteAttributeHandler
    extends ReloadRequiredWriteAttributeHandler {
        private WriteAttributeHandler(AttributeDefinition[] attributes) {
            super(attributes);
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            HttpManagementResourceDefinition.addValidatingHandler(context, operation);
        }
    }
}

