/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.as.server.deployment.Attachable;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ExternalModule;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public final class ManifestClassPathProcessor
implements DeploymentUnitProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public synchronized void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile topLevelRoot = topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT).getRoot();
        ExternalModule externalModuleService = topLevelDeployment.getAttachment(Attachments.EXTERNAL_MODULE_SERVICE);
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ServiceTarget externalServiceTarget = deploymentUnit.getAttachment(Attachments.EXTERNAL_SERVICE_TARGET);
        HashSet<VirtualFile> existingAccessibleRoots = new HashSet<VirtualFile>();
        HashMap<VirtualFile, ResourceRoot> subDeployments = new HashMap<VirtualFile, ResourceRoot>();
        for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots(topLevelDeployment)) {
            if (SubDeploymentMarker.isSubDeployment(resourceRoot)) {
                subDeployments.put(resourceRoot.getRoot(), resourceRoot);
                continue;
            }
            if (!ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
            existingAccessibleRoots.add(resourceRoot.getRoot());
        }
        ArrayDeque<RootEntry> resourceRoots = new ArrayDeque<RootEntry>();
        if (deploymentUnit.getParent() != null) {
            for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots(deploymentUnit)) {
                if (!ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
                existingAccessibleRoots.add(resourceRoot.getRoot());
            }
        }
        for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots(deploymentUnit)) {
            resourceRoots.add(new RootEntry(deploymentUnit, resourceRoot));
        }
        HashMap<VirtualFile, AdditionalModuleSpecification> hashMap = new HashMap<VirtualFile, AdditionalModuleSpecification>();
        for (AdditionalModuleSpecification module : topLevelDeployment.getAttachmentList(Attachments.ADDITIONAL_MODULES)) {
            for (ResourceRoot additionalModuleResourceRoot : module.getResourceRoots()) {
                hashMap.put(additionalModuleResourceRoot.getRoot(), module);
            }
        }
        while (!resourceRoots.isEmpty()) {
            String[] items;
            RootEntry rootEntry = (RootEntry)resourceRoots.pop();
            ResourceRoot resourceRoot = rootEntry.resourceRoot;
            Attachable target = rootEntry.target;
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) && resourceRoot != deploymentRoot) continue;
            for (String item : items = ManifestClassPathProcessor.getClassPathEntries(resourceRoot)) {
                VirtualFile file;
                if (item.isEmpty() || item.equals(".")) continue;
                VirtualFile classPathFile = resourceRoot.getRoot().getParent().getChild(item);
                VirtualFile topLevelClassPathFile = deploymentRoot.getRoot().getParent().getChild(item);
                if (item.startsWith("/")) {
                    if (externalModuleService.isValidFile(item)) {
                        ModuleIdentifier moduleIdentifier = externalModuleService.addExternalModule(item, phaseContext.getServiceRegistry(), externalServiceTarget);
                        target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, moduleIdentifier);
                        ServerLogger.DEPLOYMENT_LOGGER.debugf("Resource %s added as external jar %s", classPathFile, resourceRoot.getRoot());
                        continue;
                    }
                    ServerLogger.DEPLOYMENT_LOGGER.classPathEntryNotValid(item, resourceRoot.getRoot().getPathName());
                    continue;
                }
                if (classPathFile.exists()) {
                    boolean found = false;
                    for (file = classPathFile.getParent(); file != null; file = file.getParent()) {
                        if (!file.equals(topLevelRoot)) continue;
                        found = true;
                    }
                    if (!found) {
                        ServerLogger.DEPLOYMENT_LOGGER.classPathEntryNotValid(item, resourceRoot.getRoot().getPathName());
                        continue;
                    }
                    this.handlingExistingClassPathEntry(resourceRoots, topLevelDeployment, topLevelRoot, subDeployments, hashMap, existingAccessibleRoots, resourceRoot, target, classPathFile);
                    continue;
                }
                if (topLevelClassPathFile.exists()) {
                    boolean found = false;
                    for (file = topLevelClassPathFile.getParent(); file != null; file = file.getParent()) {
                        if (!file.equals(topLevelRoot)) continue;
                        found = true;
                    }
                    if (!found) {
                        ServerLogger.DEPLOYMENT_LOGGER.classPathEntryNotValid(item, resourceRoot.getRoot().getPathName());
                        continue;
                    }
                    this.handlingExistingClassPathEntry(resourceRoots, topLevelDeployment, topLevelRoot, subDeployments, hashMap, existingAccessibleRoots, resourceRoot, target, topLevelClassPathFile);
                    continue;
                }
                ServerLogger.DEPLOYMENT_LOGGER.classPathEntryNotValid(item, resourceRoot.getRoot().getPathName());
            }
        }
    }

    private void handlingExistingClassPathEntry(ArrayDeque<RootEntry> resourceRoots, DeploymentUnit topLevelDeployment, VirtualFile topLevelRoot, Map<VirtualFile, ResourceRoot> subDeployments, Map<VirtualFile, AdditionalModuleSpecification> additionalModules, Set<VirtualFile> existingAccessibleRoots, ResourceRoot resourceRoot, Attachable target, VirtualFile classPathFile) throws DeploymentUnitProcessingException {
        if (existingAccessibleRoots.contains(classPathFile)) {
            ServerLogger.DEPLOYMENT_LOGGER.debugf("Class-Path entry %s in %s ignored, as target is already accessible", classPathFile, resourceRoot.getRoot());
        } else if (additionalModules.containsKey(classPathFile)) {
            AdditionalModuleSpecification moduleSpecification = additionalModules.get(classPathFile);
            target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, moduleSpecification.getModuleIdentifier());
        } else if (subDeployments.containsKey(classPathFile)) {
            ResourceRoot otherRoot = subDeployments.get(classPathFile);
            target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, ModuleIdentifierProcessor.createModuleIdentifier(otherRoot.getRootName(), otherRoot, topLevelDeployment, topLevelRoot, false));
        } else {
            ModuleIdentifier identifier = this.createAdditionalModule(resourceRoot, topLevelDeployment, topLevelRoot, additionalModules, classPathFile, resourceRoots);
            target.addToAttachmentList(Attachments.CLASS_PATH_ENTRIES, identifier);
        }
    }

    private ModuleIdentifier createAdditionalModule(ResourceRoot resourceRoot, DeploymentUnit topLevelDeployment, VirtualFile topLevelRoot, Map<VirtualFile, AdditionalModuleSpecification> additionalModules, VirtualFile classPathFile, ArrayDeque<RootEntry> resourceRoots) throws DeploymentUnitProcessingException {
        ResourceRoot root = this.createResourceRoot(classPathFile, topLevelDeployment, topLevelRoot);
        String pathName = root.getRoot().getPathNameRelativeTo(topLevelRoot);
        ModuleIdentifier identifier = ModuleIdentifier.create((String)("deployment." + topLevelDeployment.getName() + "." + pathName));
        AdditionalModuleSpecification module = new AdditionalModuleSpecification(identifier, root);
        topLevelDeployment.addToAttachmentList(Attachments.ADDITIONAL_MODULES, module);
        additionalModules.put(classPathFile, module);
        resourceRoot.addToAttachmentList(Attachments.CLASS_PATH_RESOURCE_ROOTS, root);
        resourceRoots.add(new RootEntry(module, root));
        return identifier;
    }

    private static String[] getClassPathEntries(ResourceRoot resourceRoot) {
        Manifest manifest;
        try {
            manifest = VFSUtils.getManifest((VirtualFile)resourceRoot.getRoot());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (manifest == null) {
            return EMPTY_STRING_ARRAY;
        }
        String classPathString = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (classPathString == null) {
            return EMPTY_STRING_ARRAY;
        }
        return classPathString.split("\\s+");
    }

    private synchronized ResourceRoot createResourceRoot(VirtualFile file, DeploymentUnit deploymentUnit, VirtualFile deploymentRoot) throws DeploymentUnitProcessingException {
        try {
            Map<String, MountedDeploymentOverlay> overlays = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
            String relativeName = file.getPathNameRelativeTo(deploymentRoot);
            MountedDeploymentOverlay overlay = overlays.get(relativeName);
            Closeable closable = null;
            if (overlay != null) {
                overlay.remountAsZip(false);
            } else if (file.isFile()) {
                closable = VFS.mountZip((VirtualFile)file, (VirtualFile)file, (TempFileProvider)TempFileProviderService.provider());
            }
            MountHandle mountHandle = MountHandle.create(closable);
            ResourceRoot resourceRoot = new ResourceRoot(file, mountHandle);
            ModuleRootMarker.mark(resourceRoot);
            ResourceRootIndexer.indexResourceRoot(resourceRoot);
            return resourceRoot;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }

    private class RootEntry {
        private final ResourceRoot resourceRoot;
        private final Attachable target;

        private RootEntry(Attachable target, ResourceRoot resourceRoot) {
            this.target = target;
            this.resourceRoot = resourceRoot;
        }
    }
}

