/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.annotation.ResourceRootIndexer;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ModuleIndexBuilder;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public class CompositeIndexProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Index index;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        Boolean computeCompositeIndex = deploymentUnit.getAttachment(Attachments.COMPUTE_COMPOSITE_ANNOTATION_INDEX);
        if (computeCompositeIndex != null && !computeCompositeIndex.booleanValue()) {
            return;
        }
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        HashMap<ModuleIdentifier, AdditionalModuleSpecification> additionalModuleSpecificationMap = new HashMap<ModuleIdentifier, AdditionalModuleSpecification>();
        for (AdditionalModuleSpecification i : top.getAttachmentList(Attachments.ADDITIONAL_MODULES)) {
            additionalModuleSpecificationMap.put(i.getModuleIdentifier(), i);
        }
        HashMap<ModuleIdentifier, CompositeIndex> additionalAnnotationIndexes = new HashMap<ModuleIdentifier, CompositeIndex>();
        List<ModuleIdentifier> additionalModuleIndexes = deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_ANNOTATION_INDEXES);
        ArrayList<Index> indexes = new ArrayList<Index>();
        Map<ModuleIdentifier, DeploymentUnit> subdeploymentDependencies = this.buildSubdeploymentDependencyMap(deploymentUnit);
        for (ModuleIdentifier moduleIdentifier : additionalModuleIndexes) {
            AdditionalModuleSpecification additional = (AdditionalModuleSpecification)additionalModuleSpecificationMap.get(moduleIdentifier);
            if (additional != null) {
                ArrayList<Index> moduleIndexes = new ArrayList<Index>();
                for (ResourceRoot resource : additional.getResourceRoots()) {
                    ResourceRootIndexer.indexResourceRoot(resource);
                    Index indexAttachment = resource.getAttachment(Attachments.ANNOTATION_INDEX);
                    if (indexAttachment == null) continue;
                    indexes.add(indexAttachment);
                    moduleIndexes.add(indexAttachment);
                }
                if (moduleIndexes.isEmpty()) continue;
                additionalAnnotationIndexes.put(moduleIdentifier, new CompositeIndex(moduleIndexes));
                continue;
            }
            if (subdeploymentDependencies.containsKey(moduleIdentifier)) {
                ResourceRoot deploymentRoot;
                List resourceRoots = subdeploymentDependencies.get(moduleIdentifier).getAttachment(Attachments.RESOURCE_ROOTS);
                ArrayList<ResourceRoot> arrayList = new ArrayList<ResourceRoot>();
                if (resourceRoots != null) {
                    arrayList.addAll(resourceRoots);
                }
                if (ModuleRootMarker.isModuleRoot(deploymentRoot = subdeploymentDependencies.get(moduleIdentifier).getAttachment(Attachments.DEPLOYMENT_ROOT))) {
                    arrayList.add(deploymentRoot);
                }
                ArrayList<Index> moduleIndexes = new ArrayList<Index>();
                for (ResourceRoot resourceRoot : arrayList) {
                    Index index2 = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
                    if (index2 == null) continue;
                    indexes.add(index2);
                    moduleIndexes.add(index2);
                }
                if (moduleIndexes.isEmpty()) continue;
                additionalAnnotationIndexes.put(moduleIdentifier, new CompositeIndex(moduleIndexes));
                continue;
            }
            try {
                Module module = moduleLoader.loadModule(moduleIdentifier);
                CompositeIndex compositeIndex = ModuleIndexBuilder.buildCompositeIndex(module);
                if (compositeIndex != null) {
                    indexes.addAll(compositeIndex.indexes);
                    additionalAnnotationIndexes.put(moduleIdentifier, compositeIndex);
                    continue;
                }
                index = this.calculateModuleIndex(module);
                indexes.add(index);
            }
            catch (ModuleLoadException e) {
                throw new DeploymentUnitProcessingException(e);
            }
            catch (IOException e) {
                throw new DeploymentUnitProcessingException(e);
            }
        }
        deploymentUnit.putAttachment(Attachments.ADDITIONAL_ANNOTATION_INDEXES_BY_MODULE, additionalAnnotationIndexes);
        ArrayList<? extends ResourceRoot> allResourceRoots = new ArrayList<ResourceRoot>();
        List<ResourceRoot> resourceRoots = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : resourceRoots) {
            if (SubDeploymentMarker.isSubDeployment(resourceRoot) || !ModuleRootMarker.isModuleRoot(resourceRoot)) continue;
            allResourceRoots.add(resourceRoot);
        }
        allResourceRoots.addAll(this.handleClassPathItems(deploymentUnit));
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (ModuleRootMarker.isModuleRoot(deploymentRoot)) {
            allResourceRoots.add(deploymentRoot);
        }
        for (ResourceRoot resourceRoot : allResourceRoots) {
            index = resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null) continue;
            indexes.add(index);
        }
        deploymentUnit.putAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX, new CompositeIndex(indexes));
    }

    private Map<ModuleIdentifier, DeploymentUnit> buildSubdeploymentDependencyMap(DeploymentUnit deploymentUnit) {
        HashSet<ModuleIdentifier> depModuleIdentifiers = new HashSet<ModuleIdentifier>();
        for (ModuleDependency dep : deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION).getAllDependencies()) {
            depModuleIdentifiers.add(dep.getIdentifier());
        }
        DeploymentUnit top = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        HashMap<ModuleIdentifier, DeploymentUnit> res = new HashMap<ModuleIdentifier, DeploymentUnit>();
        AttachmentList<DeploymentUnit> subDeployments = top.getAttachment(Attachments.SUB_DEPLOYMENTS);
        if (subDeployments != null) {
            for (DeploymentUnit subDeployment : subDeployments) {
                ModuleIdentifier moduleIdentifier = subDeployment.getAttachment(Attachments.MODULE_IDENTIFIER);
                if (!depModuleIdentifiers.contains(moduleIdentifier)) continue;
                res.put(moduleIdentifier, subDeployment);
            }
        }
        return res;
    }

    private Collection<? extends ResourceRoot> handleClassPathItems(DeploymentUnit deploymentUnit) {
        HashSet<ResourceRoot> additionalRoots = new HashSet<ResourceRoot>();
        ArrayDeque<ResourceRoot> toProcess = new ArrayDeque<ResourceRoot>();
        List<ResourceRoot> resourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        toProcess.addAll(resourceRoots);
        HashSet<ResourceRoot> processed = new HashSet<ResourceRoot>(resourceRoots);
        while (!toProcess.isEmpty()) {
            ResourceRoot root = (ResourceRoot)toProcess.pop();
            List<ResourceRoot> classPathRoots = root.getAttachmentList(Attachments.CLASS_PATH_RESOURCE_ROOTS);
            for (ResourceRoot cpRoot : classPathRoots) {
                if (processed.contains(cpRoot)) continue;
                additionalRoots.add(cpRoot);
                toProcess.add(cpRoot);
                processed.add(cpRoot);
            }
        }
        return additionalRoots;
    }

    private Index calculateModuleIndex(Module module) throws ModuleLoadException, IOException {
        Indexer indexer = new Indexer();
        PathFilter filter = PathFilters.getDefaultImportFilter();
        Iterator iterator = module.iterateResources(filter);
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            if (!resource.getName().endsWith(".class")) continue;
            try {
                InputStream in = resource.openStream();
                Throwable throwable = null;
                try {
                    indexer.index(in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                ServerLogger.DEPLOYMENT_LOGGER.cannotIndexClass(resource.getName(), resource.getURL().toExternalForm(), e);
            }
        }
        return indexer.complete();
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
        deploymentUnit.removeAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
    }
}

