/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RuntimeExpressionResolver
extends ExpressionResolverImpl {
    private static final Logger log = Logger.getLogger(RuntimeExpressionResolver.class);
    private static final String EXPRESSION_RESOLVER_CAPABILITY = "org.wildfly.controller.expression-resolver";

    protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
        String expression = node.asString();
        if (expression.length() > 3) {
            String expressionValue = expression.substring(2, expression.length() - 1);
            if (context != null) {
                try {
                    ExpressionResolver expressionResolver = (ExpressionResolver)context.getCapabilityRuntimeAPI(EXPRESSION_RESOLVER_CAPABILITY, ExpressionResolver.class);
                    ModelNode result = expressionResolver.resolveExpressions(node, context);
                    if (result != null) {
                        node.set(result.asString());
                    }
                }
                catch (IllegalStateException e) {
                    log.tracef("Not resolving %s -- runtime capability not available.", (Object)expressionValue);
                }
            }
        }
    }
}

