/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentExplodeHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;

    public DeploymentExplodeHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        byte[] newHash;
        boolean enabled;
        if (context.getProcessType() == ProcessType.SELF_CONTAINED) {
            throw ServerLogger.ROOT_LOGGER.cannotExplodeDeploymentOfSelfContainedServer();
        }
        ModelNode explodedPath = DeploymentAttributes.DEPLOYMENT_CONTENT_PATH.resolveModelAttribute(context, operation);
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode contentItem = DeploymentHandlerUtil.getContentItem(resource);
        if (!DeploymentHandlerUtil.isManaged(contentItem)) {
            throw ServerLogger.ROOT_LOGGER.cannotExplodeUnmanagedDeployment();
        }
        if (!DeploymentHandlerUtil.isArchive(contentItem) && !explodedPath.isDefined()) {
            throw ServerLogger.ROOT_LOGGER.cannotExplodeAlreadyExplodedDeployment();
        }
        if (DeploymentHandlerUtil.isArchive(contentItem) && explodedPath.isDefined()) {
            throw ServerLogger.ROOT_LOGGER.cannotExplodeSubDeploymentOfUnexplodedDeployment();
        }
        ModelNode model = resource.getModel();
        if (context.isNormalServer() && (enabled = DeploymentAttributes.ENABLED.resolveModelAttribute(context, model).asBoolean())) {
            throw ServerLogger.ROOT_LOGGER.cannotExplodeEnabledDeployment();
        }
        final byte[] oldHash = DeploymentAttributes.CONTENT_HASH.resolveModelAttribute(context, contentItem).asBytes();
        try {
            newHash = explodedPath.isDefined() ? this.contentRepository.explodeSubContent(oldHash, explodedPath.asString()) : this.contentRepository.explodeContent(oldHash);
        }
        catch (ExplodedContentException e) {
            throw DeploymentHandlerUtils.createFailureException(e.toString());
        }
        contentItem.get(DeploymentAttributes.CONTENT_HASH.getName()).set(newHash);
        contentItem.get(DeploymentAttributes.CONTENT_ARCHIVE.getName()).set(false);
        DeploymentHandlerUtils.addFlushHandler(context, this.contentRepository, new OperationContext.ResultHandler(){

            public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                if (resultAction == OperationContext.ResultAction.KEEP) {
                    PathAddress address = context.getCurrentAddress();
                    DeploymentExplodeHandler.this.contentRepository.removeContent(ModelContentReference.fromModelAddress(address, oldHash));
                    DeploymentExplodeHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(context.getCurrentAddress(), newHash));
                }
            }
        });
    }
}

