/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.DeploymentHandlerUtils;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.deployment.transformation.DeploymentTransformer;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentAddHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "add";
    protected final ContentRepository contentRepository;
    private final DeploymentTransformer deploymentTransformer;

    protected DeploymentAddHandler(ContentRepository contentRepository) {
        assert (contentRepository != null) : "Null contentRepository";
        this.contentRepository = contentRepository;
        this.deploymentTransformer = DeploymentHandlerUtil.loadDeploymentTransformer();
    }

    public static DeploymentAddHandler create(ContentRepository contentRepository) {
        return new DeploymentAddHandler(contentRepository);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode content;
        DeploymentHandlerUtil.ContentItem contentItem;
        boolean persistent;
        if (!operation.hasDefined(DeploymentAttributes.PERSISTENT.getName())) {
            operation.get(DeploymentAttributes.PERSISTENT.getName()).set(true);
        }
        Resource resource = Resource.Factory.create((!(persistent = DeploymentAttributes.PERSISTENT.resolveModelAttribute(context, operation).asBoolean()) ? 1 : 0) != 0);
        context.addResource(PathAddress.EMPTY_ADDRESS, resource);
        ModelNode newModel = resource.getModel();
        DeploymentAttributes.PERSISTENT.validateAndSet(operation, newModel);
        DeploymentAttributes.OWNER.validateAndSet(operation, newModel);
        for (AttributeDefinition def : DeploymentAttributes.SERVER_ADD_ATTRIBUTES) {
            def.validateAndSet(operation, newModel);
        }
        ModelNode contentItemNode = newModel.require(DeploymentAttributes.CONTENT_RESOURCE_ALL.getName()).require(0);
        ModelNode opAddr = operation.get("address");
        final PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
        final String name = address.getLastElement().getValue();
        String runtimeName = operation.hasDefined(DeploymentAttributes.RUNTIME_NAME.getName()) ? operation.get(DeploymentAttributes.RUNTIME_NAME.getName()).asString() : name;
        newModel.get(DeploymentAttributes.RUNTIME_NAME.getName()).set(runtimeName);
        if (contentItemNode.hasDefined(DeploymentAttributes.CONTENT_HASH.getName())) {
            contentItem = this.addFromHash(contentItemNode, name, address, context);
        } else if (contentItemNode.hasDefined(DeploymentAttributes.EMPTY.getName())) {
            contentItem = this.addEmptyContentDir();
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(contentItem.getHash());
            contentItemNode.get(DeploymentAttributes.CONTENT_ARCHIVE.getName()).set(false);
            content = new ModelNode();
            content.add(contentItemNode);
            newModel.get(DeploymentAttributes.CONTENT_RESOURCE_ALL.getName()).set(content);
        } else if (DeploymentHandlerUtils.hasValidContentAdditionParameterDefined(contentItemNode)) {
            contentItem = this.addFromContentAdditionParameter(context, contentItemNode, name);
            contentItemNode = new ModelNode();
            contentItemNode.get(DeploymentAttributes.CONTENT_HASH.getName()).set(contentItem.getHash());
            content = new ModelNode();
            content.add(contentItemNode);
            newModel.get(DeploymentAttributes.CONTENT_RESOURCE_ALL.getName()).set(content);
        } else {
            contentItem = this.addUnmanaged(contentItemNode);
        }
        if (context.getProcessType() == ProcessType.STANDALONE_SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    DeploymentAddHandler.this.validateRuntimeNames(name, context);
                }
            }, OperationContext.Stage.MODEL);
        }
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, newModel).asBoolean() && context.isNormalServer()) {
            DeploymentHandlerUtil.deploy(context, operation, runtimeName, name, contentItem);
            DeploymentUtils.enableAttribute(newModel);
        }
        if (contentItem.getHash() != null) {
            final byte[] contentHash = contentItem.getHash();
            DeploymentHandlerUtils.addFlushHandler(context, this.contentRepository, new OperationContext.ResultHandler(){

                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (resultAction == OperationContext.ResultAction.KEEP) {
                        DeploymentAddHandler.this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, contentHash));
                    }
                }
            });
        }
    }

    private void validateRuntimeNames(String deploymentName, OperationContext context) throws OperationFailedException {
        ModelNode deployment = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        if (DeploymentAttributes.ENABLED.resolveModelAttribute(context, deployment).asBoolean()) {
            String runtimeName = DeploymentAddHandler.getRuntimeName(deploymentName, deployment);
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS);
            for (Resource.ResourceEntry re : root.getChildren("deployment")) {
                String otherRuntimeName;
                ModelNode otherDepl;
                String reName = re.getName();
                if (deploymentName.equals(reName) || !DeploymentAttributes.ENABLED.resolveModelAttribute(context, otherDepl = re.getModel()).asBoolean() || !runtimeName.equals(otherRuntimeName = DeploymentAddHandler.getRuntimeName(reName, otherDepl))) continue;
                throw ServerLogger.ROOT_LOGGER.runtimeNameMustBeUnique(reName, runtimeName);
            }
        }
    }

    private static String getRuntimeName(String name, ModelNode deployment) {
        return deployment.hasDefined("runtime-name") ? deployment.get("runtime-name").asString() : name;
    }

    DeploymentHandlerUtil.ContentItem addFromHash(ModelNode contentItem, String deploymentName, PathAddress address, OperationContext context) throws OperationFailedException {
        return new DeploymentHandlerUtil.ContentItem(DeploymentHandlerUtil.addFromHash(this.contentRepository, contentItem, deploymentName, address, context), DeploymentHandlerUtil.isArchive(contentItem));
    }

    DeploymentHandlerUtil.ContentItem addEmptyContentDir() throws OperationFailedException {
        try {
            return new DeploymentHandlerUtil.ContentItem(this.contentRepository.addContent(null));
        }
        catch (IOException e) {
            throw DeploymentHandlerUtils.createFailureException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DeploymentHandlerUtil.ContentItem addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode, String name) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentHandlerUtils.getInputStream(context, contentItemNode);
        InputStream transformed = null;
        try {
            try {
                transformed = DeploymentHandlerUtil.transformDeploymentBytes(context, contentItemNode, name, in, this.deploymentTransformer);
                hash = this.contentRepository.addContent(transformed);
            }
            catch (IOException e) {
                throw DeploymentHandlerUtils.createFailureException(e.toString());
            }
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose((Closeable)in);
            StreamUtils.safeClose(transformed);
            throw throwable;
        }
        StreamUtils.safeClose((Closeable)in);
        StreamUtils.safeClose((Closeable)transformed);
        return new DeploymentHandlerUtil.ContentItem(hash);
    }

    DeploymentHandlerUtil.ContentItem addUnmanaged(ModelNode contentItemNode) throws OperationFailedException {
        String path = contentItemNode.require(DeploymentAttributes.CONTENT_PATH.getName()).asString();
        String relativeTo = DeploymentHandlerUtils.asString(contentItemNode, DeploymentAttributes.CONTENT_RELATIVE_TO.getName());
        boolean archive = contentItemNode.require(DeploymentAttributes.CONTENT_ARCHIVE.getName()).asBoolean();
        return new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
    }
}

