/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deploymentoverlay;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.operations.CompositeOperationAwareTransformer;
import org.jboss.as.controller.operations.OperationAttachments;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.as.server.deploymentoverlay.DeploymentOverlayContentDefinition;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;

public class DeploymentOverlayContentAdd
extends AbstractAddStepHandler {
    protected final ContentRepository contentRepository;
    private final DeploymentFileRepository remoteRepository;

    public DeploymentOverlayContentAdd(ContentRepository contentRepository, DeploymentFileRepository remoteRepository) {
        this.contentRepository = contentRepository;
        this.remoteRepository = remoteRepository;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        byte[] hash;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String path = address.getLastElement().getValue();
        String name = address.getElement(address.size() - 2).getValue();
        ModelNode content = DeploymentOverlayContentDefinition.CONTENT_PARAMETER.validateOperation(operation);
        DeploymentOverlayContentAdd.validateOnePieceOfContent(content);
        if (content.hasDefined("hash")) {
            hash = content.require("hash").asBytes();
            this.addFromHash(hash, name, path, address, context);
        } else {
            hash = this.addFromContentAdditionParameter(context, content);
            ModelNode slave = operation.clone();
            slave.get("content").clear();
            slave.get("content").get("hash").set(hash);
            ArrayList<CompositeOperationAwareTransformer> transformers = (ArrayList<CompositeOperationAwareTransformer>)context.getAttachment(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS);
            if (transformers == null) {
                transformers = new ArrayList<CompositeOperationAwareTransformer>();
                context.attach(OperationAttachments.SLAVE_SERVER_OPERATION_TRANSFORMERS, transformers);
            }
            transformers.add(new CompositeOperationAwareTransformer(slave));
        }
        this.contentRepository.addContentReference(ModelContentReference.fromModelAddress(address, hash));
        ModelNode modified = operation.clone();
        modified.get("content").clone();
        modified.get("content").set(hash);
        for (AttributeDefinition attr : DeploymentOverlayContentDefinition.attributes()) {
            attr.validateAndSet(modified, resource.getModel());
        }
        if (!this.contentRepository.syncContent(ModelContentReference.fromModelAddress(address, hash))) {
            throw ServerLogger.ROOT_LOGGER.noSuchDeploymentContent(Arrays.toString(hash));
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    protected static void validateOnePieceOfContent(ModelNode content) throws OperationFailedException {
        if (content.asList().size() != 1) {
            throw ServerLogger.ROOT_LOGGER.multipleContentItemsNotSupported();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] addFromHash(byte[] hash, String deploymentOverlayName, String contentName, PathAddress address, OperationContext context) throws OperationFailedException {
        ContentReference reference = ModelContentReference.fromModelAddress(address, hash);
        if (this.remoteRepository != null) {
            this.remoteRepository.getDeploymentFiles(reference);
        }
        if (this.contentRepository.syncContent(reference)) return hash;
        if (!context.isBooting()) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash));
        if (context.getRunningMode() != RunningMode.ADMIN_ONLY) throw ServerLogger.ROOT_LOGGER.noSuchDeploymentOverlayContentAtBoot(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        ServerLogger.ROOT_LOGGER.reportAdminOnlyMissingDeploymentOverlayContent(HashUtil.bytesToHexString((byte[])hash), deploymentOverlayName, contentName);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] addFromContentAdditionParameter(OperationContext context, ModelNode contentItemNode) throws OperationFailedException {
        byte[] hash;
        InputStream in = DeploymentOverlayContentAdd.getInputStream(context, contentItemNode);
        try {
            try {
                hash = this.contentRepository.addContent(in);
            }
            catch (IOException e) {
                throw DeploymentOverlayContentAdd.createFailureException(e.toString());
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)in);
        }
        return hash;
    }

    protected static OperationFailedException createFailureException(String msg) {
        return new OperationFailedException(msg);
    }

    protected static InputStream getInputStream(OperationContext context, ModelNode operation) throws OperationFailedException {
        InputStream in = null;
        if (operation.hasDefined("input-stream-index")) {
            int maxIndex;
            int streamIndex = operation.get("input-stream-index").asInt();
            if (streamIndex > (maxIndex = context.getAttachmentStreamCount())) {
                throw ServerLogger.ROOT_LOGGER.invalidStreamIndex("input-stream-index", streamIndex, maxIndex);
            }
            in = context.getAttachmentStream(streamIndex);
        } else {
            if (operation.hasDefined("bytes")) {
                try {
                    in = new ByteArrayInputStream(operation.get("bytes").asBytes());
                }
                catch (IllegalArgumentException iae) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamBytes("bytes");
                }
            }
            if (operation.hasDefined("url")) {
                String urlSpec = operation.get("url").asString();
                try {
                    in = new URL(urlSpec).openStream();
                }
                catch (MalformedURLException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
                catch (IOException e) {
                    throw ServerLogger.ROOT_LOGGER.invalidStreamURL(e, urlSpec);
                }
            }
        }
        if (in == null) {
            throw new IllegalStateException();
        }
        return in;
    }
}

